/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deployhub;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DeployHub
extends Recorder {
    private boolean debug = false;
    private final String username;
    private final String password;
    private boolean deployApplication;
    private boolean useAdvanced;
    private boolean findLatestVersion;
    private boolean createNewVersion;
    private boolean useComponent;
    private boolean createNewComponent;
    private String environment;
    private String application;
    private boolean wait;
    private String branchName;
    private String taskname;
    private List<Attribute> appatts;
    private String componentName;
    private String componentBranchName;
    private List<Attribute> compatts;
    private String compsel;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundConstructor
    public DeployHub(String username, String password, boolean deployApplication, boolean useAdvanced, boolean findLatestVersion, boolean createNewVersion, boolean useComponent, boolean createNewComponent, String environment, String application, boolean wait, String branchName, String taskname, List<Attribute> appatts, String componentName, String compsel, String componentBranchName, List<Attribute> compatts) {
        this.username = username;
        this.password = password;
        this.deployApplication = deployApplication;
        this.useAdvanced = useAdvanced;
        this.findLatestVersion = findLatestVersion;
        this.createNewVersion = createNewVersion;
        this.useComponent = useComponent;
        this.createNewComponent = createNewComponent;
        this.environment = environment;
        this.application = application;
        this.wait = wait;
        this.branchName = branchName;
        this.taskname = taskname;
        this.appatts = appatts;
        this.componentName = componentName;
        this.componentBranchName = componentBranchName;
        this.compatts = compatts;
        this.compsel = compsel == null ? (componentName != null ? "namedcomp" : "allcomps") : compsel;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getDeployApplication() {
        return this.deployApplication;
    }

    public boolean getUseAdvanced() {
        return this.useAdvanced;
    }

    public boolean getFindLatestVersion() {
        return this.findLatestVersion;
    }

    public boolean getCreateNewVersion() {
        return this.createNewVersion;
    }

    public boolean getUseComponent() {
        return this.useComponent;
    }

    public boolean getCreateNewComponent() {
        return this.createNewComponent;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getApplication() {
        return this.application;
    }

    public boolean getWait() {
        return this.wait;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getTaskname() {
        return this.taskname;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentBranchName() {
        return this.componentBranchName;
    }

    public List<Attribute> getAppatts() {
        return this.appatts;
    }

    public List<Attribute> getCompatts() {
        return this.compatts;
    }

    public boolean isWait() {
        return this.getWait();
    }

    public boolean getNamedComp() {
        System.out.println("getNamedComp");
        if (this.compsel == null) {
            return this.componentName != null;
        }
        return this.compsel.equalsIgnoreCase("namedcomp");
    }

    public boolean getAllComps() {
        System.out.println("getAllComps");
        if (this.compsel == null) {
            return this.componentName == null;
        }
        return this.compsel.equalsIgnoreCase("allcomps");
    }

    private JSONArray getJA(JSONObject x, String y) {
        JSONArray ja = null;
        try {
            ja = x.getJSONArray(y);
        }
        catch (JSONException ex) {
            ja = null;
        }
        return ja;
    }

    private JSONObject getJO(JSONObject x, String y) {
        JSONObject jo = null;
        try {
            jo = x.getJSONObject(y);
            if (jo.isNullObject()) {
                jo = null;
            }
        }
        catch (JSONException ex) {
            jo = null;
        }
        return jo;
    }

    private JSONObject SendMessage(BuildListener listener, CookieManager cm, String urlstr) {
        if (this.debug) {
            listener.getLogger().println("DEBUG: " + urlstr);
        }
        JSONObject err = new JSONObject();
        err.element("success", false);
        try {
            URL url = new URL(urlstr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                return err.element("error", conn.getResponseCode());
            }
            String reply = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String l = null;
            StringBuffer buf = new StringBuffer();
            while ((l = br.readLine()) != null) {
                if (this.debug) {
                    listener.getLogger().println("DEBUG: " + l);
                }
                buf.append(l);
            }
            reply = buf.toString();
            br.close();
            JSONObject res = JSONObject.fromObject((Object)reply);
            conn.disconnect();
            return res;
        }
        catch (MalformedURLException ex) {
            return err.element("error", (Object)("Malformed URL: " + urlstr));
        }
        catch (IOException ex) {
            return err.element("error", (Object)("IO Exception: " + ex.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String server = this.getDescriptor().getServerURL();
        this.debug = false;
        try {
            JSONObject depres;
            JSONArray applist;
            JSONObject a;
            String expbranch;
            EnvVars e = build.getEnvironment((TaskListener)listener);
            String expapp = e.expand(this.application);
            String expenv = e.expand(this.environment);
            String branchname = this.getBranchName();
            String string = expbranch = branchname != null && branchname.length() > 0 ? e.expand(branchname) : null;
            if (this.debug) {
                listener.getLogger().println("Server is " + server);
                listener.getLogger().println("Application is " + expapp);
                listener.getLogger().println("Environment is " + expenv);
            }
            String buildno = e.expand("$BUILD_NUMBER");
            System.out.println("Build Number is " + buildno);
            String jobname = e.expand("$JOB_NAME");
            System.out.println("Job Name is " + jobname);
            String buildurl = e.expand("$BUILD_URL");
            System.out.println("Build URL is " + buildurl);
            CookieManager cm = new CookieManager();
            cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cm);
            String urlstr = server + "/dmadminweb/API/login?user=" + URLEncoder.encode(this.username, "UTF-8") + "&pass=" + URLEncoder.encode(this.password, "UTF-8");
            JSONObject res = this.SendMessage(listener, cm, urlstr);
            if (!res.getBoolean("success")) {
                listener.getLogger().print("Failed to login to DeployHub as user " + this.username + ":");
                listener.getLogger().println(res.getString("error"));
                return false;
            }
            listener.getLogger().println("Logged in to DeployHub as user " + this.username);
            JSONObject app = null;
            int appid = 0;
            String appname = null;
            boolean newVersionCreated = false;
            if (!this.getDeployApplication()) {
                urlstr = server + "/dmadminweb/API/buildnotify?buildurl=" + URLEncoder.encode(buildurl, "UTF-8");
                res = this.SendMessage(listener, cm, urlstr);
                System.out.println("res=" + res.toString());
                return true;
            }
            System.out.println("Deploy Application is set");
            if (this.getFindLatestVersion()) {
                urlstr = server + "/dmadminweb/API/application/" + URLEncoder.encode(expapp, "UTF-8") + "?latest=Y";
                if (expbranch != null) {
                    urlstr = urlstr + "&branch=" + URLEncoder.encode(expbranch, "UTF-8");
                }
            } else {
                urlstr = server + "/dmadminweb/API/application/" + URLEncoder.encode(expapp, "UTF-8");
            }
            if (!(a = this.SendMessage(listener, cm, urlstr)).getBoolean("success")) {
                listener.getLogger().println(a.getString("error"));
                return false;
            }
            app = this.getJO(a, "result");
            appid = app.getInt("id");
            appname = app.getString("name");
            if (this.debug) {
                listener.getLogger().println("appid=" + appid);
            }
            if (this.getCreateNewVersion() && (applist = this.getJA(app, "approvals")).size() > 0) {
                listener.getLogger().println("Application " + appname + " is approved - creating new version");
                urlstr = server + "/dmadminweb/API/newappver/" + appid + "?taskname=" + URLEncoder.encode(this.getTaskname(), "UTF-8");
                JSONObject na = this.SendMessage(listener, cm, urlstr);
                if (!na.getBoolean("success")) {
                    listener.getLogger().println(na.getString("error"));
                    return false;
                }
                app = this.getJO(na, "result");
                System.out.println("app is " + app);
                appid = app.getInt("id");
                appname = app.getString("name");
                System.out.println("appid=" + appid + " appname=" + appname);
                listener.getLogger().println("New Application Version " + appname + " created");
                newVersionCreated = true;
            }
            if (this.getUseComponent()) {
                JSONArray applist2;
                String cn = this.getComponentName();
                if (cn.length() == 0) {
                    listener.getLogger().println("Component Name not specified");
                    return false;
                }
                urlstr = server + "/dmadminweb/API/component/" + URLEncoder.encode(cn, "UTF-8");
                JSONObject c = this.SendMessage(listener, cm, urlstr);
                if (!c.getBoolean("success")) {
                    listener.getLogger().println(c.getString("error"));
                    return false;
                }
                JSONObject comp = this.getJO(c, "result");
                String compname = comp.getString("name");
                int compid = comp.getInt("id");
                JSONArray cvs = this.getJA(comp, "versions");
                ArrayList<Integer> compids = new ArrayList<Integer>();
                compids.add(compid);
                if (cvs != null) {
                    for (int i = 0; i < cvs.size(); ++i) {
                        JSONObject c2 = cvs.getJSONObject(i);
                        compids.add(c2.getInt("id"));
                    }
                }
                if (this.debug) {
                    listener.getLogger().println("compids=" + compids);
                }
                if (this.debug) {
                    listener.getLogger().println("app=" + app);
                }
                JSONArray appcomps = this.getJA(app, "components");
                compid = 0;
                if (this.debug) {
                    listener.getLogger().println("appcomps=" + appcomps);
                }
                if (appcomps != null) {
                    for (int i = 0; i < appcomps.size(); ++i) {
                        int mc;
                        JSONObject ac = appcomps.getJSONObject(i);
                        if (this.debug) {
                            listener.getLogger().println("ac=" + ac);
                        }
                        int aci = ac.getInt("id");
                        if (this.debug) {
                            listener.getLogger().println("aci=" + aci);
                        }
                        if ((mc = compids.indexOf(aci)) < 0) continue;
                        compid = (Integer)compids.get(mc);
                        compname = ac.getString("name");
                        listener.getLogger().println("Component " + compname + " is associated with application " + appname);
                        break;
                    }
                }
                if (compid == 0) {
                    listener.getLogger().println("No version of Component " + cn + " is present in Application " + appname);
                    return false;
                }
                urlstr = server + "/dmadminweb/API/component/" + compid;
                JSONObject cx = this.SendMessage(listener, cm, urlstr);
                if (!cx.getBoolean("success")) {
                    listener.getLogger().println(cx.getString("error"));
                    return false;
                }
                comp = this.getJO(cx, "result");
                compname = comp.getString("name");
                compid = comp.getInt("id");
                boolean CreateNewComponentVersion = false;
                if (!newVersionCreated && (applist2 = this.getJA(comp, "applications")) != null) {
                    for (int i = 0; i < applist2.size(); ++i) {
                        JSONArray tapp;
                        JSONObject ta = applist2.getJSONObject(i);
                        if (this.debug) {
                            listener.getLogger().println("ta=" + ta);
                        }
                        if ((tapp = this.getJA(ta, "approvals")) == null || tapp.size() <= 0) continue;
                        listener.getLogger().println("Component " + comp.getString("name") + " is associated with an approved application " + ta.getString("name"));
                        CreateNewComponentVersion = true;
                        break;
                    }
                }
                if (newVersionCreated || CreateNewComponentVersion) {
                    urlstr = server + "/dmadminweb/API/newcompver/" + compid;
                    JSONObject nc = this.SendMessage(listener, cm, urlstr);
                    if (!nc.getBoolean("success")) {
                        listener.getLogger().println(nc.getString("error"));
                        return false;
                    }
                    JSONObject newcomp = this.getJO(nc, "result");
                    int newcompid = newcomp.getInt("id");
                    String newcompname = newcomp.getString("name");
                    listener.getLogger().println("New Component Version " + newcomp.getString("name") + " created");
                    if (newVersionCreated) {
                        urlstr = server + "/dmadminweb/API/replace/" + appid + "/" + compid + "/" + newcompid;
                        nc = this.SendMessage(listener, cm, urlstr);
                        if (!nc.getBoolean("success")) {
                            listener.getLogger().println(nc.getString("error"));
                            return false;
                        }
                        listener.getLogger().println("Component " + compname + " replaced with new version " + newcompname + " in Application " + appname);
                    }
                    comp = newcomp;
                    compid = newcompid;
                    compname = newcompname;
                }
                boolean titlePrinted = false;
                List<Attribute> compatts = this.getCompatts();
                if (compatts != null) {
                    for (Attribute xa : compatts) {
                        String expvalue;
                        String name = xa.getName();
                        String value = xa.getValue();
                        String expname = name != null ? e.expand(name) : "";
                        String string2 = expvalue = value != null ? e.expand(value) : "";
                        if (expname == null || expvalue == null || expname.length() <= 0 || expvalue.length() <= 0) continue;
                        if (!titlePrinted) {
                            listener.getLogger().println("Setting Attributes on Component \"" + compname + "\"");
                            titlePrinted = true;
                        }
                        listener.getLogger().println("Setting \"" + expname + "\" to \"" + expvalue + "\"");
                        urlstr = server + "/dmadminweb/API/setvar/component/" + compid + "?name=" + URLEncoder.encode(expname, "UTF-8") + "&value=" + URLEncoder.encode(expvalue, "UTF-8");
                        JSONObject res2 = this.SendMessage(listener, cm, urlstr);
                        if (res2.getBoolean("success")) continue;
                        listener.getLogger().println(res2.getString("error"));
                        return false;
                    }
                }
            }
            boolean titlePrinted = false;
            List<Attribute> appatts = this.getAppatts();
            if (appatts != null) {
                for (Attribute aa : appatts) {
                    if (!titlePrinted) {
                        listener.getLogger().println("Setting Attributes on Application \"" + appname + "\"");
                        titlePrinted = true;
                    }
                    try {
                        String name = aa.getName();
                        String value = aa.getValue();
                        String expname = name != null ? e.expand(name) : "";
                        String expvalue = value != null ? e.expand(value) : "";
                        listener.getLogger().println("Setting \"" + expname + "\" to \"" + expvalue + "\"");
                        urlstr = server + "/dmadminweb/API/setvar/application/" + appid + "?name=" + URLEncoder.encode(expname, "UTF-8") + "&value=" + URLEncoder.encode(expvalue, "UTF-8");
                        JSONObject res2 = this.SendMessage(listener, cm, urlstr);
                        if (res2.getBoolean("success")) continue;
                        listener.getLogger().println(res2.getString("error"));
                        return false;
                    }
                    catch (JSONException name) {
                    }
                }
            }
            urlstr = server + "/dmadminweb/API/buildnotify?buildurl=" + URLEncoder.encode(buildurl, "UTF-8");
            res = this.SendMessage(listener, cm, urlstr);
            System.out.println("res=" + res.toString());
            listener.getLogger().print("Deploying application " + appname);
            listener.getLogger().println(" to environment " + expenv);
            String waitstr = "N";
            if (this.wait) {
                waitstr = "Y";
            }
            if (!(depres = this.SendMessage(listener, cm, urlstr = server + "/dmadminweb/API/deploy/" + appid + "?env=" + URLEncoder.encode(expenv, "UTF-8") + "&wait=" + waitstr)).getBoolean("success")) {
                listener.getLogger().println(depres.getString("error"));
                return false;
            }
            int deploymentid = depres.getInt("deploymentid");
            if (this.wait) {
                urlstr = server + "/dmadminweb/API/log?id=" + deploymentid;
                JSONObject logres = this.SendMessage(listener, cm, urlstr);
                if (!logres.getBoolean("success")) {
                    listener.getLogger().println(logres.getString("error"));
                    return false;
                }
                JSONArray logoutput = this.getJA(logres, "logoutput");
                if (logoutput == null) {
                    listener.getLogger().println("could not find logoutput in returned JSON");
                    return false;
                }
                for (int i = 0; i < logoutput.size(); ++i) {
                    String logline = logoutput.getString(i);
                    listener.getLogger().println(logline);
                }
            } else {
                listener.getLogger().println("Deployment #" + deploymentid + " started");
            }
            String rootDir = build.getProject().getRootDir().getAbsolutePath();
            XmlFile t = new XmlFile(Hudson.XSTREAM, new File(rootDir, "DeployHub.xml"));
            if (t == null) return true;
            JSONObject mydata = new JSONObject();
            if (t.exists()) {
                t.unmarshal((Object)mydata);
            }
            mydata.put("LastBuild", (Object)buildno);
            mydata.put("DeploymentID", (Object)deploymentid);
            t.write((Object)mydata);
            return true;
        }
        catch (IOException ex) {
            listener.getLogger().println("IO Exception: " + ex.getMessage());
            return false;
        }
        catch (InterruptedException ex) {
            listener.getLogger().println("Interrupted Exception: " + ex.getMessage());
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String serverURL;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckApplication(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for the application");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironment(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for the environment");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for the username");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for the password");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class aClass) {
            return true;
        }

        public String getDisplayName() {
            return "DeployHub Interface";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.serverURL = formData.getString("serverURL");
            this.save();
            return super.configure(req, formData);
        }

        public String getServerURL() {
            return this.serverURL;
        }
    }

    public static class Attribute
    extends AbstractDescribableImpl<Attribute> {
        public String name;
        public String value;

        @DataBoundConstructor
        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Attribute> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

