/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.velocity.marathon.impl;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.mesosphere.velocity.marathon.exceptions.MarathonFileInvalidException;
import com.mesosphere.velocity.marathon.exceptions.MarathonFileMissingException;
import com.mesosphere.velocity.marathon.fields.MarathonLabel;
import com.mesosphere.velocity.marathon.fields.MarathonUri;
import com.mesosphere.velocity.marathon.interfaces.AppConfig;
import com.mesosphere.velocity.marathon.interfaces.MarathonBuilder;
import com.mesosphere.velocity.marathon.util.MarathonBuilderUtils;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.MarathonClient;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.utils.MarathonException;
import mesosphere.marathon.client.utils.ModelUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class MarathonBuilderImpl
extends MarathonBuilder {
    private AppConfig config;
    private JSONObject json;
    private App app;
    private EnvVars envVars;
    private FilePath workspace;

    public MarathonBuilderImpl() {
        this(null);
    }

    public MarathonBuilderImpl(AppConfig config) {
        this.config = config;
        this.envVars = new EnvVars();
    }

    public String getUrl() {
        return this.config.getUrl();
    }

    public List<MarathonUri> getUris() {
        return this.config.getUris();
    }

    public List<MarathonLabel> getLabels() {
        return this.config.getLabels();
    }

    public String getAppid() {
        return this.config.getAppId();
    }

    public String getDocker() {
        return this.config.getDocker();
    }

    @Override
    public MarathonBuilder update() throws MarathonException {
        if (this.app != null) {
            UsernamePasswordCredentials usercreds = MarathonBuilderUtils.getUsernamePasswordCredentials(this.config.getCredentialsId());
            StringCredentials creds = MarathonBuilderUtils.getTokenCredentials(this.config.getCredentialsId());
            Marathon marathon = creds == null ? (usercreds == null ? MarathonClient.getInstance((String)this.config.getUrl()) : MarathonClient.getInstanceWithBasicAuth((String)this.config.getUrl(), (String)usercreds.getUsername(), (String)usercreds.getPassword().getPlainText())) : MarathonClient.getInstanceWithTokenAuth((String)this.config.getUrl(), (String)creds.getSecret().getPlainText());
            marathon.updateApp(this.app.getId(), this.app, this.config.getForceUpdate());
        }
        return this;
    }

    @Override
    public MarathonBuilder read(String filename) throws IOException, InterruptedException, MarathonFileMissingException, MarathonFileInvalidException {
        String realFilename = filename != null ? filename : "marathon.json";
        FilePath marathonFile = this.workspace.child(realFilename);
        if (!marathonFile.exists()) {
            throw new MarathonFileMissingException(realFilename);
        }
        if (marathonFile.isDirectory()) {
            throw new MarathonFileInvalidException("File '" + realFilename + "' is a directory.");
        }
        String content = marathonFile.readToString();
        this.json = JSONObject.fromObject((Object)content);
        return this;
    }

    @Override
    public MarathonBuilder read() throws IOException, InterruptedException, MarathonFileMissingException, MarathonFileInvalidException {
        return this.read(null);
    }

    @Override
    public MarathonBuilder setJson(JSONObject json) {
        this.json = json;
        return this;
    }

    @Override
    public JSONObject getJson() {
        return this.json;
    }

    @Override
    public MarathonBuilder setEnvVars(EnvVars vars) {
        this.envVars = vars;
        return this;
    }

    @Override
    public MarathonBuilder setConfig(AppConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public MarathonBuilder setWorkspace(FilePath ws) {
        this.workspace = ws;
        return this;
    }

    @Override
    public MarathonBuilder build() {
        this.setId();
        this.setDockerImage();
        this.setUris();
        this.setLabels();
        this.app = (App)ModelUtils.GSON.fromJson(this.json.toString(), App.class);
        return this;
    }

    @Override
    public MarathonBuilder toFile(String filename) throws InterruptedException, IOException, MarathonFileInvalidException {
        String realFilename = filename != null ? filename : "marathon-rendered-${BUILD_NUMBER}.json";
        FilePath renderedFilepath = this.workspace.child(Util.replaceMacro((String)realFilename, (Map)this.envVars));
        if (renderedFilepath.exists() && renderedFilepath.isDirectory()) {
            throw new MarathonFileInvalidException("File '" + realFilename + "' is a directory; not overwriting.");
        }
        renderedFilepath.write(this.json.toString(), null);
        return this;
    }

    @Override
    public MarathonBuilder toFile() throws InterruptedException, IOException, MarathonFileInvalidException {
        return this.toFile(null);
    }

    private JSONObject setId() {
        if (this.config.getAppId() != null && this.config.getAppId().trim().length() > 0) {
            this.json.put("id", (Object)Util.replaceMacro((String)this.config.getAppId(), (Map)this.envVars));
        }
        return this.json;
    }

    private JSONObject setDockerImage() {
        if (this.config.getDocker() != null && this.config.getDocker().trim().length() > 0) {
            JSONObject container;
            if (!this.json.has("container")) {
                this.json.element("container", (Map)JSONObject.fromObject((Object)"{\"type\": \"DOCKER\"}"));
            }
            if (!(container = this.json.getJSONObject("container")).has("docker")) {
                container.element("docker", (Map)new JSONObject());
            }
            container.getJSONObject("docker").element("image", (Object)Util.replaceMacro((String)this.config.getDocker(), (Map)this.envVars));
        }
        return this.json;
    }

    private JSONObject setUris() {
        if (this.config.getUris().size() > 0) {
            boolean hasUris = this.json.get("uris") instanceof JSONArray;
            if (!hasUris) {
                this.json.element("uris", (Collection)new JSONArray());
            }
            for (MarathonUri uri : this.config.getUris()) {
                this.json.accumulate("uris", (Object)Util.replaceMacro((String)uri.getUri(), (Map)this.envVars));
            }
        }
        return this.json;
    }

    private JSONObject setLabels() {
        if (!this.json.has("labels")) {
            this.json.element("labels", (Map)new JSONObject());
        }
        JSONObject labelObject = this.json.getJSONObject("labels");
        for (MarathonLabel label : this.config.getLabels()) {
            labelObject.element(Util.replaceMacro((String)label.getName(), (Map)this.envVars), (Object)Util.replaceMacro((String)label.getValue(), (Map)this.envVars));
        }
        return this.json;
    }
}

