/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.velocity.marathon;

import com.mesosphere.velocity.marathon.fields.MarathonLabel;
import com.mesosphere.velocity.marathon.fields.MarathonUri;
import com.mesosphere.velocity.marathon.interfaces.AppConfig;
import com.mesosphere.velocity.marathon.interfaces.MarathonBuilder;
import com.mesosphere.velocity.marathon.util.MarathonBuilderUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MarathonStep
extends AbstractStepImpl
implements AppConfig {
    private final String url;
    private List<String> uris;
    private Map<String, String> labels;
    private String appid;
    private String docker;
    private String filename;
    private String credentialsId;
    private boolean forceUpdate;

    @DataBoundConstructor
    public MarathonStep(String url) {
        this.url = MarathonBuilderUtils.rmSlashFromUrl(url);
        this.uris = new ArrayList<String>(5);
        this.labels = new HashMap<String, String>(5);
    }

    @Override
    public String getAppId() {
        return this.appid;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean getForceUpdate() {
        return this.forceUpdate;
    }

    @DataBoundSetter
    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    @Override
    public String getDocker() {
        return this.docker;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Override
    public List<MarathonUri> getUris() {
        ArrayList<MarathonUri> marathonUris = new ArrayList<MarathonUri>(this.uris.size());
        for (String u : this.uris) {
            marathonUris.add(new MarathonUri(u));
        }
        return marathonUris;
    }

    @DataBoundSetter
    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    @Override
    public List<MarathonLabel> getLabels() {
        ArrayList<MarathonLabel> marathonLabels = new ArrayList<MarathonLabel>(this.labels.size());
        for (Map.Entry<String, String> label : this.labels.entrySet()) {
            marathonLabels.add(new MarathonLabel(label.getKey(), label.getValue()));
        }
        return marathonLabels;
    }

    @DataBoundSetter
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @DataBoundSetter
    public void setDocker(String docker) {
        this.docker = docker;
    }

    public String getAppid() {
        return this.appid;
    }

    @DataBoundSetter
    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getFilename() {
        return this.filename;
    }

    @DataBoundSetter
    public void setFilename(@Nonnull String filename) {
        if (filename.trim().length() > 0) {
            this.filename = filename;
        }
    }

    public static class MarathonStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @Inject
        private transient MarathonStep step;

        protected Void run() throws Exception {
            MarathonBuilder.getBuilder(this.step).setEnvVars(this.envVars).setWorkspace(this.ws).read(this.step.filename).build().toFile().update();
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(MarathonStepExecution.class);
        }

        public String getFunctionName() {
            return "marathon";
        }

        @Nonnull
        public String getDisplayName() {
            return "Marathon Deployment";
        }
    }
}

