/*
 * Decompiled with CFR 0.152.
 */
package com.mesosphere.velocity.marathon;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.mesosphere.velocity.marathon.exceptions.MarathonFileInvalidException;
import com.mesosphere.velocity.marathon.exceptions.MarathonFileMissingException;
import com.mesosphere.velocity.marathon.fields.MarathonLabel;
import com.mesosphere.velocity.marathon.fields.MarathonUri;
import com.mesosphere.velocity.marathon.interfaces.AppConfig;
import com.mesosphere.velocity.marathon.interfaces.MarathonBuilder;
import com.mesosphere.velocity.marathon.util.MarathonBuilderUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import mesosphere.marathon.client.utils.MarathonException;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MarathonRecorder
extends Recorder
implements AppConfig {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(MarathonRecorder.class.getName());
    private final String url;
    private List<MarathonUri> uris;
    private List<MarathonLabel> labels;
    private String appid;
    private String docker;
    private String filename;
    private String credentialsId;
    private boolean forceUpdate;

    @DataBoundConstructor
    public MarathonRecorder(String url) {
        this.url = MarathonBuilderUtils.rmSlashFromUrl(url);
        this.uris = new ArrayList<MarathonUri>(5);
        this.labels = new ArrayList<MarathonLabel>(5);
    }

    public String getAppid() {
        return this.appid;
    }

    @DataBoundSetter
    public void setAppid(@Nonnull String appid) {
        this.appid = appid;
    }

    public String getFilename() {
        return this.filename;
    }

    @DataBoundSetter
    public void setFilename(@Nonnull String filename) {
        if (filename.trim().length() > 0) {
            this.filename = filename;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    private void log(PrintStream logger, String text) {
        logger.println("[Marathon] " + text);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean buildSucceed = build.getResult() == null || build.getResult() == Result.SUCCESS;
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        PrintStream logger = listener.getLogger();
        envVars.overrideAll(build.getBuildVariables());
        if (buildSucceed) {
            try {
                MarathonBuilder builder = MarathonBuilder.getBuilder(this).setEnvVars(envVars).setWorkspace(build.getWorkspace()).read(this.filename).build().toFile();
                boolean retry = true;
                int retryCount = 0;
                while (retry && retryCount < 3) {
                    try {
                        builder.update();
                        retry = false;
                        this.log(logger, "Marathon application updated.");
                    }
                    catch (MarathonException e) {
                        if (e.getStatus() != 409 && e.getStatus() >= 400 && e.getStatus() < 600) {
                            build.setResult(Result.FAILURE);
                            this.log(logger, "Failed to update Marathon application:");
                            this.log(logger, e.getMessage());
                            LOGGER.warning(e.getMessage());
                            retry = false;
                            continue;
                        }
                        ++retryCount;
                        Thread.sleep(5000L);
                    }
                }
                if (retry) {
                    build.setResult(Result.FAILURE);
                    this.log(logger, "Reached max retries updating Marathon application.");
                }
            }
            catch (MarathonFileMissingException e) {
                build.setResult(Result.FAILURE);
                this.log(logger, "Application Definition not found:");
                this.log(logger, e.getMessage());
            }
            catch (MarathonFileInvalidException e) {
                build.setResult(Result.FAILURE);
                this.log(logger, "Application Definition is not a file:");
                this.log(logger, e.getMessage());
            }
        }
        return build.getResult() == Result.SUCCESS;
    }

    @Override
    public String getAppId() {
        return this.appid;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean getForceUpdate() {
        return this.forceUpdate;
    }

    @Override
    public String getDocker() {
        return this.docker;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Override
    public List<MarathonUri> getUris() {
        return this.uris;
    }

    @DataBoundSetter
    public void setUris(List<MarathonUri> uris) {
        this.uris = uris;
    }

    @Override
    public List<MarathonLabel> getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setLabels(List<MarathonLabel> labels) {
        this.labels = labels;
    }

    @DataBoundSetter
    public void setDocker(@Nonnull String docker) {
        this.docker = docker;
    }

    public boolean isForceUpdate() {
        return this.getForceUpdate();
    }

    @DataBoundSetter
    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        private boolean isUrl(String url) {
            boolean valid = false;
            if (url != null && url.length() > 0) {
                try {
                    new URL(url);
                    valid = true;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return valid;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item, null, Collections.emptyList()));
        }

        private FormValidation verifyUrl(String url) {
            if (!this.isUrl(url)) {
                return FormValidation.error((String)"Not a valid URL");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            return this.verifyUrl(value);
        }

        public FormValidation doCheckUri(@QueryParameter String value) {
            return this.verifyUrl(value);
        }

        public String getDisplayName() {
            return "Marathon Deployment";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

