/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.util;

import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationRulesSet;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import com.infullmobile.jenkins.plugin.restrictedregister.verifiers.SecretKeyVerifier;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public final class SecretKeyChecker {
    private SecretKeyChecker() {
    }

    public static boolean isGetParamSecretValid() {
        String secret = null;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request.hasParameter(BaseFormField.SECRET.getFieldName())) {
            secret = request.getParameter(BaseFormField.SECRET.getFieldName());
        }
        return SecretKeyChecker.isSecretKeyValid(secret);
    }

    public static boolean isSecretKeyValid(String secret) {
        String fixedSecret = Utils.fixEmptyString(secret);
        JSONObject payload = new JSONObject();
        payload.put(BaseFormField.SECRET.getFieldName(), (Object)fixedSecret);
        SecretKeyVerifier secretKeyVerifier = new SecretKeyVerifier();
        List<RegistrationRulesSet> rules = PluginModule.getDefault().getPluginDescriptor().getGlobalConfig().getRulesList();
        for (RegistrationRulesSet rulesSet : rules) {
            if (!rulesSet.validateDataWithVerifier(payload, secretKeyVerifier)) continue;
            return true;
        }
        return rules.size() == 0;
    }
}

