/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.util;

import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.util.InvalidUriException;
import com.infullmobile.jenkins.plugin.restrictedregister.utils.Messages;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public final class AppUrls {
    private static final String FORMAT_REGISTER_PATH = "/%s/";
    private static final String FORMAT_LOGIN_PATH = "/%s";

    private AppUrls() {
    }

    @Nonnull
    public static String buildSignInUrl() throws InvalidUriException {
        String ret = null;
        String path = String.format(Locale.US, FORMAT_LOGIN_PATH, PluginModule.getDefault().getJenkinsDescriptor().getLoginURI());
        try {
            URIBuilder builder = new URIBuilder(AppUrls.getRootURL());
            builder.setPath(path);
            URI uri = builder.build();
            ret = uri.toURL().toExternalForm();
        }
        catch (MalformedURLException | URISyntaxException e) {
            AppUrls.onError(e.getLocalizedMessage());
        }
        return ret;
    }

    @Nonnull
    public static String buildActivationUrl(String code, String secret) throws InvalidUriException {
        String ret = null;
        String path = String.format(Locale.US, FORMAT_REGISTER_PATH, PluginModule.getDefault().getPluginDescriptor().getRootActionURL());
        try {
            URIBuilder builder = new URIBuilder(AppUrls.getRootURL());
            builder.setPath(path);
            builder.addParameter(BaseFormField.SECRET.getFieldName(), secret);
            builder.addParameter(BaseFormField.ACTIVATION_CODE.getFieldName(), code);
            URI uri = builder.build();
            ret = uri.toURL().toExternalForm();
        }
        catch (MalformedURLException | URISyntaxException e) {
            AppUrls.onError(e.getLocalizedMessage());
        }
        return ret;
    }

    private static String getRootURL() throws InvalidUriException {
        String ret = PluginModule.getDefault().getJenkinsDescriptor().getRootURL();
        if (StringUtils.isEmpty((String)ret)) {
            AppUrls.onError(Messages.RRUrlError_EmptyJenkinsURL());
        }
        return ret;
    }

    private static void onError(String message) throws InvalidUriException {
        throw new InvalidUriException(message);
    }
}

