/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson;

import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.HudsonSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.PluginGlobalConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RRHudsonUserProperty
extends UserProperty {
    private String activationCode;
    private boolean activated;
    private String activatedAt;
    private String ruleName;

    @DataBoundConstructor
    public RRHudsonUserProperty() {
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    @DataBoundSetter
    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public boolean getActivated() {
        return this.activated;
    }

    @DataBoundSetter
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getActivatedAt() {
        return this.activatedAt;
    }

    @DataBoundSetter
    public void setActivatedAt(String activatedAt) {
        this.activatedAt = activatedAt;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    @DataBoundSetter
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public static boolean isUserActivated(@Nonnull User user) {
        RRHudsonUserProperty userProperty = (RRHudsonUserProperty)user.getProperty(RRHudsonUserProperty.class);
        return userProperty != null && userProperty.getActivated();
    }

    public static void setUserActivated(@Nonnull User user) throws IOException {
        RRHudsonUserProperty userProperty = (RRHudsonUserProperty)user.getProperty(RRHudsonUserProperty.class);
        userProperty.setActivated(true);
        userProperty.setActivatedAt(Utils.getFormattedTimestamp(new Date()));
        user.addProperty((UserProperty)userProperty);
    }

    @Nullable
    public static User getUserForActivationCode(@Nullable String activationCode) {
        if (StringUtils.isEmpty((String)activationCode)) {
            return null;
        }
        return RRHudsonUserProperty.getUserForCode(activationCode);
    }

    @Nullable
    private static User getUserForCode(@Nonnull String activationCode) {
        ArrayList allUsers = new ArrayList(User.getAll());
        for (User user : allUsers) {
            RRHudsonUserProperty userProperty = (RRHudsonUserProperty)user.getProperty(RRHudsonUserProperty.class);
            if (userProperty == null || !activationCode.equals(userProperty.getActivationCode())) continue;
            return user;
        }
        return null;
    }

    @Nullable
    public static String getActivationCodeForUser(User user) {
        RRHudsonUserProperty hudsonUserProperty = RRHudsonUserProperty.getPropertyForUser(user);
        if (hudsonUserProperty == null) {
            return null;
        }
        return hudsonUserProperty.getActivationCode();
    }

    @Nonnull
    public static RRHudsonUserProperty obtainPropertyForUser(User user) {
        RRHudsonUserProperty ret = RRHudsonUserProperty.getPropertyForUser(user);
        if (ret == null) {
            ret = new RRHudsonUserProperty();
        }
        return ret;
    }

    @Nullable
    public static RRHudsonUserProperty getPropertyForUser(@Nullable User user) {
        if (user == null) {
            return null;
        }
        return (RRHudsonUserProperty)user.getProperty(RRHudsonUserProperty.class);
    }

    @Extension
    public static class RRUserPropertyDescriptor
    extends UserPropertyDescriptor {
        public UserProperty newInstance(User user) {
            return new RRHudsonUserProperty();
        }

        @Nonnull
        public String getDisplayName() {
            return "Restricted Registration";
        }

        public boolean isEnabled() {
            return ((PluginGlobalConfig)GlobalConfiguration.all().get(PluginGlobalConfig.class)).getEnabled() && HudsonSecurityRealmRegistration.isActive();
        }
    }
}

