/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson;

import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.mail.data.LocalVariables;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.RRHudsonUserProperty;
import com.infullmobile.jenkins.plugin.restrictedregister.util.AppUrls;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import hudson.model.User;
import hudson.tasks.Mailer;
import java.util.HashMap;
import net.sf.json.JSONObject;

public final class LocalVariablesBuilder {
    public static final String VAR_SIGN_IN_LINK = "RR_SIGN_IN_LINK";
    public static final String VAR_CONFIRMATION_LINK = "RR_CONFIRMATION_LINK";
    public static final String VAR_USER_DISPLAY_NAME = "RR_USER_DISPLAY_NAME";
    public static final String VAR_USER_EMAIL = "RR_USER_EMAIL";
    public static final String VAR_USER_ID = "RR_USER_ID";
    private User user;
    private JSONObject payload;

    private LocalVariablesBuilder() {
    }

    public LocalVariablesBuilder user(User user) {
        this.user = user;
        return this;
    }

    public LocalVariablesBuilder payload(JSONObject payload) {
        this.payload = payload;
        return this;
    }

    public static LocalVariablesBuilder start() {
        return new LocalVariablesBuilder();
    }

    public LocalVariables build() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VAR_USER_DISPLAY_NAME, Utils.escapeInputString(this.user.getFullName()));
        variables.put(VAR_USER_ID, Utils.escapeInputString(this.user.getId()));
        Mailer.UserProperty mailerProperty = (Mailer.UserProperty)this.user.getProperty(Mailer.UserProperty.class);
        if (mailerProperty != null) {
            variables.put(VAR_USER_EMAIL, Utils.escapeInputString(Utils.fixEmptyString(mailerProperty.getAddress())));
        } else {
            variables.put(VAR_USER_EMAIL, "");
        }
        String secret = (String)BaseFormField.SECRET.fromJSON(this.payload);
        String code = RRHudsonUserProperty.getActivationCodeForUser(this.user);
        variables.put(VAR_CONFIRMATION_LINK, Utils.escapeInputString(AppUrls.buildActivationUrl(code, secret)));
        variables.put(VAR_SIGN_IN_LINK, Utils.escapeInputString(AppUrls.buildSignInUrl()));
        return new LocalVariables(variables);
    }
}

