/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson;

import com.infullmobile.jenkins.plugin.restrictedregister.API;
import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.form.IFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.mail.Mail;
import com.infullmobile.jenkins.plugin.restrictedregister.mail.MailException;
import com.infullmobile.jenkins.plugin.restrictedregister.mail.data.LocalVariables;
import com.infullmobile.jenkins.plugin.restrictedregister.security.InvalidSecurityRealmException;
import com.infullmobile.jenkins.plugin.restrictedregister.security.SecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.LocalVariablesBuilder;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.Messages;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.RRHudsonUserProperty;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.ActivateFormFieldsValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.ActivationCodeFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.ExistingUserFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.HudsonFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.RegisterFormFieldsValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.mail.AdminNotificationEmail;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.mail.ConfirmationEmail;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.mail.WelcomeEmail;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationRulesSet;
import com.infullmobile.jenkins.plugin.restrictedregister.util.AuthCodeGenerator;
import com.infullmobile.jenkins.plugin.restrictedregister.util.SecretKeyChecker;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Extension
public class HudsonSecurityRealmRegistration
extends SecurityRealmRegistration<HudsonPrivateSecurityRealm>
implements Describable<HudsonSecurityRealmRegistration> {
    private final List<IFormValidator<HudsonSecurityRealmRegistration>> registerFormValidators = new ArrayList<IFormValidator<HudsonSecurityRealmRegistration>>();
    private final List<IFormValidator<HudsonSecurityRealmRegistration>> activateFormValidators = new ArrayList<IFormValidator<HudsonSecurityRealmRegistration>>();

    public HudsonSecurityRealmRegistration() {
        this.registerFormValidators.add(new ExistingUserFormValidator());
        this.registerFormValidators.add(new RegisterFormFieldsValidator());
        this.activateFormValidators.add(new ActivateFormFieldsValidator());
        this.activateFormValidators.add(new ActivationCodeFormValidator());
    }

    static boolean isActive() {
        return HudsonPrivateSecurityRealm.class.isInstance(PluginModule.getDefault().getJenkinsDescriptor().getSecurityRealm());
    }

    @Override
    public boolean isRegistrationForSecurityRealm(SecurityRealm realm) {
        return HudsonPrivateSecurityRealm.class.isInstance(realm);
    }

    @JavaScriptMethod
    public JSONObject register(JSONObject payload) {
        JSONObject ret;
        try {
            try {
                this.validateRegisterFormData(payload);
                RegistrationRulesSet matchingRules = this.findMatchingConfigRules(payload);
                if (matchingRules == null) {
                    throw new RegistrationException(Messages.RRError_NoMatchingRules());
                }
                this.initiateAccount(payload, matchingRules);
                ret = API.success();
            }
            catch (JSONException e) {
                Utils.logError(e);
                throw new RegistrationException(Messages.RRError_Hudson_InvalidEntity());
            }
        }
        catch (InvalidSecurityRealmException e) {
            ret = API.errorWithMessage(Messages.RRError_SecurityRealmNotApplicable());
        }
        catch (Exception e) {
            ret = API.errorWithException(e);
            Utils.logError(e);
        }
        return ret;
    }

    private void initiateAccount(JSONObject payload, RegistrationRulesSet matchingRules) throws RegistrationException {
        User user = User.get((String)payload.getString(BaseFormField.USERNAME.getFieldName()));
        RRHudsonUserProperty property = RRHudsonUserProperty.obtainPropertyForUser(user);
        if (property.getActivated()) {
            throw new RegistrationException(Messages.RRError_Hudson_UserIsActivated());
        }
        if (StringUtils.isEmpty((String)property.getActivationCode())) {
            property.setActivationCode(this.getNewUniqueAuthCode());
        }
        property.setRuleName(matchingRules.getRuleName());
        Mailer.UserProperty mailerProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        String emailAddress = payload.getString(BaseFormField.EMAIL.getFieldName());
        if (mailerProperty == null || !emailAddress.equals(mailerProperty.getAddress())) {
            mailerProperty = new Mailer.UserProperty(payload.getString(BaseFormField.EMAIL.getFieldName()));
        }
        try {
            user.addProperty((UserProperty)property);
            user.addProperty((UserProperty)mailerProperty);
            String userDisplayName = (String)BaseFormField.DISPLAY_NAME.fromJSON(payload);
            user.setFullName(userDisplayName);
            user.save();
        }
        catch (IOException e) {
            throw new RegistrationException(Messages.RRError_Hudson_UserIO());
        }
        try {
            Mail mail = ConfirmationEmail.create(this.createLocalVariables(payload, user), emailAddress);
            mail.send();
        }
        catch (MailException e) {
            throw new RegistrationException(Messages.RRError_Hudson_EmailAfterInitiation(emailAddress));
        }
    }

    private String getNewUniqueAuthCode() {
        String authCode;
        while (RRHudsonUserProperty.getUserForActivationCode(authCode = AuthCodeGenerator.genUniqueAuthCode()) != null) {
        }
        return authCode;
    }

    private void validateRegisterFormData(JSONObject payload) throws RegistrationException, InvalidSecurityRealmException {
        for (IFormValidator<HudsonSecurityRealmRegistration> validator : this.registerFormValidators) {
            validator.verifyFormData(this, payload);
        }
    }

    @JavaScriptMethod
    public JSONObject checkSecret(String secret) {
        if (SecretKeyChecker.isSecretKeyValid(secret)) {
            return API.success();
        }
        return API.errorWithException(new RegistrationException(Messages.RRError_Hudson_Unauthorized()));
    }

    @JavaScriptMethod
    public JSONObject checkActivationCode(String secret, String activationCode) {
        try {
            if (!SecretKeyChecker.isSecretKeyValid(secret)) {
                throw new RegistrationException(Messages.RRError_Hudson_Unauthorized());
            }
            this.validateActivationCode(activationCode);
        }
        catch (Exception e) {
            return API.errorWithException(e);
        }
        return API.success();
    }

    private void validateActivationCode(String activationCode) throws RegistrationException {
        User user = this.getUserForActivationCode(activationCode);
        if (user == null) {
            throw new RegistrationException(Messages.RRError_Hudson_ActiviationCodeInvalid());
        }
        if (RRHudsonUserProperty.isUserActivated(user)) {
            throw new RegistrationException(Messages.RRError_Hudson_UserIsActivated());
        }
    }

    public String getUsernameFromAuthCode() {
        User user;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request.hasParameter(this.getCodeParamKey()) && (user = this.getUserForActivationCode(request.getParameter(this.getCodeParamKey()))) != null) {
            return user.getId();
        }
        return "";
    }

    public User getUserForActivationCode(String activationCode) {
        return RRHudsonUserProperty.getUserForActivationCode(activationCode);
    }

    @JavaScriptMethod
    public JSONObject activate(JSONObject payload) {
        JSONObject ret;
        try {
            try {
                this.validateActivateFormData(payload);
                this.activateAccount(payload);
                ret = API.success();
            }
            catch (JSONException e) {
                Utils.logError(e);
                throw new RegistrationException(Messages.RRError_Hudson_InvalidEntity());
            }
        }
        catch (InvalidSecurityRealmException e) {
            ret = API.errorWithMessage(Messages.RRError_SecurityRealmNotApplicable());
        }
        catch (Exception e) {
            ret = API.errorWithException(e);
            Utils.logError(e);
        }
        return ret;
    }

    private void validateActivateFormData(JSONObject payload) throws RegistrationException, InvalidSecurityRealmException {
        for (IFormValidator<HudsonSecurityRealmRegistration> validator : this.activateFormValidators) {
            validator.verifyFormData(this, payload);
        }
    }

    private void activateAccount(JSONObject payload) throws InvalidSecurityRealmException, RegistrationException {
        Mail mail;
        String activationCode = (String)BaseFormField.ACTIVATION_CODE.fromJSON(payload);
        User user = RRHudsonUserProperty.getUserForActivationCode(activationCode);
        RRHudsonUserProperty hudsonUserProperty = RRHudsonUserProperty.getPropertyForUser(user);
        String password = (String)HudsonFormField.PASSWORD.fromJSON(payload);
        assert (user != null);
        assert (hudsonUserProperty != null);
        assert (password != null);
        assert (activationCode != null);
        HudsonPrivateSecurityRealm securityRealm = (HudsonPrivateSecurityRealm)this.getSecurityRealm();
        try {
            securityRealm.createAccount(user.getId(), password);
            hudsonUserProperty.setActivated(true);
            hudsonUserProperty.setActivatedAt(Utils.getFormattedTimestamp(new Date()));
            user.addProperty((UserProperty)hudsonUserProperty);
        }
        catch (IOException e) {
            Utils.logError(e);
            throw new RegistrationException(Messages.RRError_Hudson_UserIO());
        }
        Mailer.UserProperty mailerProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        String emailAddress = mailerProperty.getAddress();
        try {
            mail = WelcomeEmail.create(this.createLocalVariables(payload, user), emailAddress);
            mail.send();
        }
        catch (MailException e) {
            Utils.logError(e);
            throw new RegistrationException(Messages.RRError_Hudson_EmailErrorAfterActivation(emailAddress));
        }
        try {
            mail = AdminNotificationEmail.create(this.createLocalVariables(payload, user));
            mail.send();
        }
        catch (MailException e) {
            Utils.logError("Failed to send e-mail notification to administrator");
            Utils.logError(e);
        }
    }

    public String getCodeParamKey() {
        return BaseFormField.ACTIVATION_CODE.getFieldName();
    }

    private LocalVariables createLocalVariables(JSONObject payload, User user) {
        return LocalVariablesBuilder.start().user(user).payload(payload).build();
    }

    public Descriptor<HudsonSecurityRealmRegistration> getDescriptor() {
        return PluginModule.getDefault().getJenkinsDescriptor().getDescriptorForType(this);
    }

    @Extension
    public static class HudsonSecurityRealmRegistrationDescriptor
    extends Descriptor<HudsonSecurityRealmRegistration> {
        private static final String DISPLAY_NAME = "Hudson security realm registration";

        @Nonnull
        public String getDisplayName() {
            return DISPLAY_NAME;
        }
    }
}

