/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security;

import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.module.impl.JenkinsDescriptorImpl;
import com.infullmobile.jenkins.plugin.restrictedregister.security.InvalidSecurityRealmException;
import com.infullmobile.jenkins.plugin.restrictedregister.security.StubSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.HudsonFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.IPluginConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationRulesSet;
import hudson.ExtensionPoint;
import hudson.security.SecurityRealm;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;

public abstract class SecurityRealmRegistration<T extends SecurityRealm>
implements ExtensionPoint {
    public final T getSecurityRealm() throws InvalidSecurityRealmException {
        SecurityRealm securityRealm = JenkinsDescriptorImpl.getJenkinsInstanceOrDie().getSecurityRealm();
        if (this.isRegistrationForSecurityRealm(securityRealm)) {
            return (T)JenkinsDescriptorImpl.getJenkinsInstanceOrDie().getSecurityRealm();
        }
        throw new InvalidSecurityRealmException();
    }

    public abstract boolean isRegistrationForSecurityRealm(SecurityRealm var1);

    public RegistrationRulesSet findMatchingConfigRules(JSONObject payload) throws RegistrationException {
        IPluginConfig config = this.getConfig();
        List<RegistrationRulesSet> allRules = config.getRulesList();
        for (RegistrationRulesSet rulesSet : allRules) {
            if (!rulesSet.isUserDataValid(payload)) continue;
            return rulesSet;
        }
        return null;
    }

    public IPluginConfig getConfig() {
        return PluginModule.getDefault().getPluginDescriptor().getGlobalConfig();
    }

    public String getUsernameFormFieldName() {
        return BaseFormField.USERNAME.getFieldName();
    }

    public String getPasswordFormFieldName() {
        return HudsonFormField.PASSWORD.getFieldName();
    }

    public String getRepeatPasswordFormFieldName() {
        return HudsonFormField.PASSWORD_REPEAT.getFieldName();
    }

    public String getEmailFormFieldName() {
        return BaseFormField.EMAIL.getFieldName();
    }

    public String getDisplayNameFormFieldName() {
        return BaseFormField.DISPLAY_NAME.getFieldName();
    }

    public String getSecretFormFieldName() {
        return BaseFormField.SECRET.getFieldName();
    }

    public String getActivationCodeFormFieldName() {
        return BaseFormField.ACTIVATION_CODE.getFieldName();
    }

    public static boolean isStubSecurityRealm(@Nonnull SecurityRealmRegistration wrapper) {
        return StubSecurityRealmRegistration.class.equals(wrapper.getClass());
    }
}

