/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.jenkins.reporting.cucumber;

import com.github.bogdanlivadariu.jenkins.reporting.cucumber.CucumberTestReportBuildAction;
import com.github.bogdanlivadariu.jenkins.reporting.cucumber.CucumberTestReportProjectAction;
import com.github.bogdanlivadariu.reporting.cucumber.builder.CucumberReportBuilder;
import com.github.bogdanlivadariu.reporting.cucumber.helpers.SpecialProperties;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Result;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CucumberTestReportPublisher
extends Recorder {
    private static final String DEFAULT_FILE_INCLUDE_PATTERN = "**/*.json";
    private final String jsonReportDirectory;
    private final String fileIncludePattern;
    private final String fileExcludePattern;
    private final boolean markAsUnstable;
    private final boolean copyHTMLInWorkspace;
    private final boolean ignoreUndefinedSteps;
    private final SpecialProperties props;

    @DataBoundConstructor
    public CucumberTestReportPublisher(String jsonReportDirectory, String fileIncludePattern, String fileExcludePattern, boolean markAsUnstable, boolean copyHTMLInWorkspace, boolean ignoreUndefinedSteps) {
        this.jsonReportDirectory = jsonReportDirectory;
        this.fileIncludePattern = fileIncludePattern;
        this.fileExcludePattern = fileExcludePattern;
        this.markAsUnstable = markAsUnstable;
        this.copyHTMLInWorkspace = copyHTMLInWorkspace;
        this.ignoreUndefinedSteps = ignoreUndefinedSteps;
        SpecialProperties props = new SpecialProperties();
        props.getProperties().put(SpecialProperties.SpecialKeyProperties.IGNORE_UNDEFINED_STEPS, this.isIgnoreUndefinedSteps());
        this.props = props;
    }

    public String getJsonReportDirectory() {
        return this.jsonReportDirectory;
    }

    public String getFileIncludePattern() {
        return this.fileIncludePattern;
    }

    public String getFileExcludePattern() {
        return this.fileExcludePattern;
    }

    public boolean isMarkAsUnstable() {
        return this.markAsUnstable;
    }

    public boolean isCopyHTMLInWorkspace() {
        return this.copyHTMLInWorkspace;
    }

    public boolean isIgnoreUndefinedSteps() {
        return this.ignoreUndefinedSteps;
    }

    private String[] findJsonFiles(File targetDirectory, String fileIncludePattern, String fileExcludePattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (fileIncludePattern == null || fileIncludePattern.isEmpty()) {
            scanner.setIncludes(new String[]{DEFAULT_FILE_INCLUDE_PATTERN});
        } else {
            scanner.setIncludes(new String[]{fileIncludePattern});
        }
        if (fileExcludePattern != null) {
            scanner.setExcludes(new String[]{fileExcludePattern});
        }
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    /*
     * Unable to fully structure code
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("[CucumberReportPublisher] Compiling Cucumber Html Reports ...");
        workspaceJsonReportDirectory = this.getJsonReportDirectory().isEmpty() != false ? build.getWorkspace() : new FilePath(build.getWorkspace(), this.getJsonReportDirectory());
        targetBuildDirectory = new File(build.getRootDir(), "cucumber-reports-with-handlebars");
        if (!targetBuildDirectory.exists()) {
            targetBuildDirectory.mkdirs();
        }
        if (Computer.currentComputer() instanceof SlaveComputer) {
            listener.getLogger().println("[Cucumber test report builder] Copying JSON files from slave: " + workspaceJsonReportDirectory.getRemote() + " to master reports directory: " + targetBuildDirectory);
        } else {
            listener.getLogger().println("[Cucumber test report builder] Copying JSON files from: " + workspaceJsonReportDirectory.getRemote() + " to reports directory: " + targetBuildDirectory);
        }
        targetBuildJsonDirectory = new File(targetBuildDirectory.getAbsolutePath() + "/jsonData");
        if (!targetBuildJsonDirectory.exists()) {
            targetBuildJsonDirectory.mkdirs();
        }
        includePattern = this.fileIncludePattern == null || this.fileIncludePattern.isEmpty() != false ? "**/*.json" : this.fileIncludePattern;
        workspaceJsonReportDirectory.copyRecursiveTo(includePattern, new FilePath(targetBuildJsonDirectory));
        result = Result.NOT_BUILT;
        jsonReportFiles = this.findJsonFiles(targetBuildJsonDirectory, this.getFileIncludePattern(), this.getFileExcludePattern());
        if (jsonReportFiles.length > 0) {
            listener.getLogger().println(String.format("[CucumberReportPublisher] Found %d json files.", new Object[]{jsonReportFiles.length}));
            jsonIndex = 0;
            for (String jsonReportFile : jsonReportFiles) {
                listener.getLogger().println("[Cucumber test report builder] " + jsonIndex + ". Found a json file: " + jsonReportFile);
                ++jsonIndex;
            }
            listener.getLogger().println("[Cucumber test report builder] Generating HTML reports");
            try {
                fullJsonPaths = new ArrayList<String>();
                for (String fi : jsonReportFiles) {
                    fullJsonPaths.add(targetBuildJsonDirectory + "/" + fi);
                }
                for (String ss : this.fullPathToJsonFiles(jsonReportFiles, targetBuildJsonDirectory)) {
                    listener.getLogger().println("processing: " + ss);
                }
                rep = new CucumberReportBuilder(this.fullPathToJsonFiles(jsonReportFiles, targetBuildJsonDirectory), targetBuildDirectory.getAbsolutePath(), this.props);
                featuresResult = rep.writeReportsOnDisk();
                if (featuresResult) {
                    result = Result.SUCCESS;
                } else {
                    v0 = result = this.isMarkAsUnstable() != false ? Result.UNSTABLE : Result.FAILURE;
                }
                if (!this.isCopyHTMLInWorkspace()) ** GOTO lbl60
                workspaceCopyDirectory = new FilePath(build.getWorkspace(), "cucumber-reports-with-handlebars");
                if (workspaceCopyDirectory.exists()) {
                    workspaceCopyDirectory.deleteRecursive();
                }
                listener.getLogger().println("[Cucumber test report builder] Copying report to workspace directory: " + workspaceCopyDirectory.toURI());
                new FilePath(targetBuildDirectory).copyRecursiveTo("**/*.html", workspaceCopyDirectory);
            }
            catch (Exception e) {
                result = Result.FAILURE;
                listener.getLogger().println("[Cucumber test report builder] there was an error generating the reports: " + e);
                for (StackTraceElement error : e.getStackTrace()) {
                    listener.getLogger().println(error);
                }
            }
        } else {
            result = Result.SUCCESS;
            listener.getLogger().println("[Cucumber test report builder] json path for the reports might be wrong, " + targetBuildDirectory);
        }
lbl60:
        // 4 sources

        build.addAction((Action)new CucumberTestReportBuildAction(build));
        build.setResult(result);
        return true;
    }

    private List<String> fullPathToJsonFiles(String[] jsonFiles, File targetBuildDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : jsonFiles) {
            fullPathList.add(new File(targetBuildDirectory, file).getAbsolutePath());
        }
        return fullPathList;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CucumberTestReportProjectAction((AbstractItem)project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish cucumber reports generated with handlebars";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

