/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.jenkins.reporting.junit;

import com.github.bogdanlivadariu.jenkins.reporting.junit.JUnitTestReportProjectAction;
import com.github.bogdanlivadariu.jenkins.reporting.junit.JunitTestReportBuildAction;
import com.github.bogdanlivadariu.reporting.junit.builder.JUnitReportBuilder;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Result;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class JUnitTestReportPublisher
extends Recorder {
    private static final String DEFAULT_FILE_INCLUDE_PATTERN = "**/*.xml";
    public final String jsonReportDirectory;
    public final String fileIncludePattern;
    public final String fileExcludePattern;

    @DataBoundConstructor
    public JUnitTestReportPublisher(String jsonReportDirectory, String fileIncludePattern, String fileExcludePattern) {
        this.jsonReportDirectory = jsonReportDirectory;
        this.fileIncludePattern = fileIncludePattern;
        this.fileExcludePattern = fileExcludePattern;
    }

    private String[] findJsonFiles(File targetDirectory, String fileIncludePattern, String fileExcludePattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (fileIncludePattern == null || fileIncludePattern.isEmpty()) {
            scanner.setIncludes(new String[]{DEFAULT_FILE_INCLUDE_PATTERN});
        } else {
            scanner.setIncludes(new String[]{fileIncludePattern});
        }
        if (fileExcludePattern != null) {
            scanner.setExcludes(new String[]{fileExcludePattern});
        }
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    /*
     * Unable to fully structure code
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        block10: {
            listener.getLogger().println("[JUnitReportPublisher] Compiling JUnit Html Reports ...");
            workspaceJsonReportDirectory = this.jsonReportDirectory.isEmpty() != false ? build.getWorkspace() : new FilePath(build.getWorkspace(), this.jsonReportDirectory);
            targetBuildDirectory = new File(build.getRootDir(), "junit-reports-with-handlebars");
            if (!targetBuildDirectory.exists()) {
                targetBuildDirectory.mkdirs();
            }
            if (Computer.currentComputer() instanceof SlaveComputer) {
                listener.getLogger().println("[JUnit test report builder] Copying all xml files from slave: " + workspaceJsonReportDirectory.getRemote() + " to master reports directory: " + targetBuildDirectory);
            } else {
                listener.getLogger().println("[JUnit test report builder] Copying all xml files from: " + workspaceJsonReportDirectory.getRemote() + " to reports directory: " + targetBuildDirectory);
            }
            targetBuildJsonDirectory = new File(String.valueOf(targetBuildDirectory.getAbsolutePath()) + "/xmlData");
            workspaceJsonReportDirectory.copyRecursiveTo("**/*.xml", new FilePath(targetBuildJsonDirectory));
            result = Result.NOT_BUILT;
            jsonReportFiles = this.findJsonFiles(targetBuildJsonDirectory, this.fileIncludePattern, this.fileExcludePattern);
            if (jsonReportFiles.length > 0) {
                listener.getLogger().println(String.format("[JUnitReportPublisher] Found %d xml files.", new Object[]{jsonReportFiles.length}));
                jsonIndex = 0;
                var13_10 = jsonReportFiles;
                var12_13 = jsonReportFiles.length;
                var11_16 = 0;
                while (var11_16 < var12_13) {
                    jsonReportFile = var13_10[var11_16];
                    listener.getLogger().println("[JUnit test report builder] " + jsonIndex + ". Found a xml file: " + jsonReportFile);
                    ++jsonIndex;
                    ++var11_16;
                }
                listener.getLogger().println("[JUnit test report builder] Generating HTML reports");
                try {
                    fullJsonPaths = new ArrayList<String>();
                    var14_23 = jsonReportFiles;
                    var13_11 = jsonReportFiles.length;
                    var12_13 = 0;
                    while (var12_13 < var13_11) {
                        fi = var14_23[var12_13];
                        fullJsonPaths.add(targetBuildJsonDirectory + "/" + fi);
                        ++var12_13;
                    }
                    for (String ss : this.fullPathToXmlFiles(jsonReportFiles, targetBuildJsonDirectory)) {
                        listener.getLogger().println("processing: " + ss);
                    }
                    rep = new JUnitReportBuilder(this.fullPathToXmlFiles(jsonReportFiles, targetBuildJsonDirectory), targetBuildDirectory.getAbsolutePath());
                    featuresResult = rep.writeReportsOnDisk();
                    result = featuresResult ? Result.SUCCESS : Result.FAILURE;
                    break block10;
                }
                catch (Exception e) {
                    result = Result.FAILURE;
                    listener.getLogger().println("[JUnit test report builder] there was an error generating the reports: " + e);
                    var14_24 = e.getStackTrace();
                    var13_12 = var14_24.length;
                    var12_13 = 0;
                    ** while (var12_13 < var13_12)
                }
lbl-1000:
                // 1 sources

                {
                    error = var14_24[var12_13];
                    listener.getLogger().println(error);
                    ++var12_13;
                    continue;
lbl58:
                    // 1 sources

                    break block10;
                }
            }
            result = Result.SUCCESS;
            listener.getLogger().println("[JUnit test report builder] xml path for the reports might be wrong, " + targetBuildDirectory);
        }
        build.addAction((Action)new JunitTestReportBuildAction(build));
        build.setResult(result);
        return true;
    }

    private List<String> fullPathToXmlFiles(String[] xmlFiles, File targetBuildDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        String[] stringArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            fullPathList.add(new File(targetBuildDirectory, file).getAbsolutePath());
            ++n2;
        }
        return fullPathList;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new JUnitTestReportProjectAction((AbstractItem)project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish JUnit reports generated with handlebars";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

