/*
 * Decompiled with CFR 0.152.
 */
package com.exxeta.jenkins.plugins.sidebar.updatenotification;

import com.exxeta.jenkins.plugins.sidebar.updatenotification.JenkinsPermissionValidator;
import com.exxeta.jenkins.plugins.sidebar.updatenotification.Messages;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.UpdateCenter;
import jenkins.model.Jenkins;

@Extension(ordinal=1.0)
public class PluginUpdateAvailableAction
implements RootAction {
    private UpdateCenter updateCenter = Jenkins.getInstance().getUpdateCenter();

    public String getIconFileName() {
        if (this.updateCenter.getUpdates().isEmpty() || JenkinsPermissionValidator.userHasNoAdministerPermission()) {
            return null;
        }
        return "refresh.png";
    }

    public String getDisplayName() {
        int availableUpdateCount = this.updateCenter.getUpdates().size();
        if (availableUpdateCount == 1) {
            return Messages.JenkinsPluginSingleUpdateAvailable();
        }
        return String.format(Messages.JenkinsPluginMultipleUpdatesAvailable(), availableUpdateCount);
    }

    public String getUrlName() {
        return "/pluginManager";
    }
}

