/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.util;

import hudson.model.TaskListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskLogger {
    private static final String PREFIX = "[Kubernetes cloud] - ";
    private final TaskListener taskListener;
    private final Logger logger;

    public TaskLogger(TaskListener listener, Logger logger) {
        this.taskListener = listener;
        this.logger = logger;
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public void info(String msg) {
        this.logger.info(msg);
        this.taskListener.getLogger().println(PREFIX + msg);
    }

    public void info(String format, Object ... args) {
        this.logger.log(Level.INFO, format, args);
        this.taskListener.getLogger().println(PREFIX + MessageFormat.format(format, args));
    }

    public void error(String msg) {
        this.logger.severe(msg);
        this.taskListener.error(PREFIX + msg + "\n");
    }

    public void error(String format, Object ... args) {
        this.logger.log(Level.SEVERE, format, args);
        this.taskListener.error(PREFIX + MessageFormat.format(format, args) + "\n");
    }
}

