/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.elasticbox.jenkins.k8s.auth.TokenAuthentication;
import com.elasticbox.jenkins.k8s.auth.UserAndPasswordAuthentication;
import com.elasticbox.jenkins.k8s.plugin.auth.TokenCredentialsImpl;
import com.elasticbox.jenkins.k8s.util.KeyValuePair;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public class PluginHelper {
    public static final String DEFAULT_NAMESPACE = "default";
    private static final ListBoxModel.Option OPTION_CHOOSE_CHART = new ListBoxModel.Option("--Please choose the chart to use--", "");
    private static final ListBoxModel.Option OPTION_CHOOSE_NAMESPACE = new ListBoxModel.Option("--Please choose the namespace--", "");
    public static final ListBoxModel.Option OPTION_CHOOSE_CLOUD = new ListBoxModel.Option("--Please choose your cloud--", "");
    public static final ListBoxModel.Option OPTION_CHOOSE_CHART_REPO_CONFIG = new ListBoxModel.Option("--Please choose your chart repository configuration--", "");

    public static boolean anyOfThemIsBlank(String ... inputParameters) {
        for (String inputParameter : inputParameters) {
            if (!StringUtils.isBlank((String)inputParameter)) continue;
            return true;
        }
        return false;
    }

    public static void addAllPairs(ListBoxModel listBoxItems, List<KeyValuePair<String, String>> newItems) {
        for (KeyValuePair<String, String> pair : newItems) {
            listBoxItems.add(pair.getValue(), pair.getKey());
        }
    }

    public static ListBoxModel addAllItems(ListBoxModel listBoxItems, List<String> newItems) {
        for (String item : newItems) {
            listBoxItems.add(item);
        }
        return listBoxItems;
    }

    public static ListBoxModel doFillChartItems(List<String> chartsList) {
        ListBoxModel items = new ListBoxModel(new ListBoxModel.Option[]{OPTION_CHOOSE_CHART});
        if (chartsList != null) {
            PluginHelper.addAllItems(items, chartsList);
        }
        return items;
    }

    public static ListBoxModel doFillNamespaceItems(List<String> namespaces) {
        ListBoxModel items = new ListBoxModel(new ListBoxModel.Option[]{OPTION_CHOOSE_NAMESPACE});
        if (namespaces != null) {
            PluginHelper.addAllItems(items, namespaces);
        }
        return items;
    }

    public static com.elasticbox.jenkins.k8s.auth.Authentication getAuthenticationData(String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        com.elasticbox.jenkins.k8s.auth.Authentication authData = null;
        StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (credentials instanceof TokenCredentialsImpl) {
            TokenCredentialsImpl tokenCredentials = (TokenCredentialsImpl)credentials;
            authData = new TokenAuthentication(tokenCredentials.getSecret().getPlainText());
        } else if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials userPw = (UsernamePasswordCredentials)credentials;
            authData = new UserAndPasswordAuthentication(userPw.getUsername(), userPw.getPassword().getPlainText());
        }
        return authData;
    }

    public static ListBoxModel doFillCredentialsIdItems(String endpointUrl) {
        return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(TokenCredentialsImpl.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)endpointUrl).build()));
    }
}

