/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesSlave;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.elasticbox.jenkins.k8s.services.task.ScheduledPoolingTask;
import com.elasticbox.jenkins.k8s.services.task.TaskException;
import com.google.inject.Singleton;
import hudson.slaves.SlaveComputer;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public class WaitForSlaveToBeOnline
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(WaitForSlaveToBeOnline.class.getName());
    private static final long DELAY_IN_SECONDS = 1L;
    private static final long INITIAL_DELAY_IN_SECONDS = 0L;
    private static final long TIMEOUT_IN_SECONDS = 60L;
    private long initialDelay;
    private long delay;
    private long timeout;

    public WaitForSlaveToBeOnline() {
        this(0L, 1L, 60L);
    }

    public WaitForSlaveToBeOnline(long initialDelay, long delay, long timeout) {
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeout = timeout;
    }

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        try {
            KubernetesSlave kubernetesSlave = deploymentContext.getKubernetesSlave();
            new WaitForTheSlaveToBeOnlineTask(kubernetesSlave, this.delay, this.initialDelay, this.timeout).execute();
            LOGGER.log(Level.INFO, "Jenkins slave: " + kubernetesSlave.getNodeName() + " is online");
        }
        catch (TaskException error) {
            LOGGER.log(Level.SEVERE, "Error waiting for the Jenkins slave to be online", error);
            throw new ServiceException("Error waiting for the Jenkins slave to be online", error);
        }
    }

    private static class WaitForTheSlaveToBeOnlineTask
    extends ScheduledPoolingTask<Boolean> {
        private KubernetesSlave slave;

        public WaitForTheSlaveToBeOnlineTask(KubernetesSlave slave, long delay, long initialDelay, long timeout) {
            super(delay, initialDelay, timeout);
            this.slave = slave;
            this.result = false;
        }

        @Override
        protected void performExecute() throws TaskException {
            SlaveComputer computer = this.slave.getComputer();
            if (computer == null) {
                LOGGER.warning("Computer is null for the slave: " + (Object)((Object)this.slave));
                return;
            }
            this.result = computer.isOnline();
            LOGGER.log(Level.INFO, "Jenkins slave is online: " + this.result);
        }

        @Override
        public boolean isDone() {
            return (Boolean)this.result;
        }
    }
}

