/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesSlave;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import hudson.model.Descriptor;
import hudson.model.Node;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Singleton
public class AddSlaveToJenkinsCloud
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(AddSlaveToJenkinsCloud.class.getName());
    private static final String JENKINS_SLAVE_NAME_PREFIX = "jenkins-slave";
    @Inject
    private PodRepository podRepository;

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        StringBuilder builder = new StringBuilder(JENKINS_SLAVE_NAME_PREFIX);
        builder.append("-");
        builder.append(Long.toHexString(System.nanoTime()));
        String podName = builder.toString();
        try {
            KubernetesSlave slave = new KubernetesSlave(podName, this.podRepository, deploymentContext.getCloudToDeployInto(), deploymentContext.getJobLabel());
            Jenkins.getInstance().addNode((Node)slave);
            LOGGER.log(Level.INFO, "Added: " + slave.getNodeName() + " to Jenkins cloud");
            deploymentContext.setKubernetesSlave(slave);
        }
        catch (Descriptor.FormException | IOException exception) {
            LOGGER.log(Level.SEVERE, "Error creating the KubernetesSlave ", exception);
            throw new ServiceException(exception);
        }
    }
}

