/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfigurationParams;
import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesSlave;
import hudson.model.Label;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.List;

public class PodDeploymentContext {
    private Label jobLabel;
    private List<PodSlaveConfigurationParams> availablePodConfigurations;
    private Pod podToDeploy;
    private PodSlaveConfigurationParams podConfigurationChosen;
    private KubernetesCloud cloudToDeployInto;
    private String deploymentNamespace;
    private KubernetesSlave kubernetesSlave;

    private PodDeploymentContext(JenkinsPodSlaveDeploymentContextBuilder builder) {
        this.jobLabel = builder.jobLabel;
        this.availablePodConfigurations = builder.podConfigurations;
        this.cloudToDeployInto = builder.kubernetesCloud;
        this.deploymentNamespace = builder.deploymentNamespace;
    }

    public PodSlaveConfigurationParams getPodConfigurationChosen() {
        return this.podConfigurationChosen;
    }

    public String getDeploymentNamespace() {
        return this.deploymentNamespace;
    }

    public Label getJobLabel() {
        return this.jobLabel;
    }

    public KubernetesCloud getCloudToDeployInto() {
        return this.cloudToDeployInto;
    }

    public Pod getPodToDeploy() {
        return this.podToDeploy;
    }

    public List<PodSlaveConfigurationParams> getAvailablePodConfigurations() {
        return this.availablePodConfigurations;
    }

    public void setPodToDeploy(Pod podToDeploy) {
        this.podToDeploy = podToDeploy;
    }

    public void setPodConfigurationChosen(PodSlaveConfigurationParams podConfigurationChosen) {
        this.podConfigurationChosen = podConfigurationChosen;
    }

    public KubernetesSlave getKubernetesSlave() {
        return this.kubernetesSlave;
    }

    public void setKubernetesSlave(KubernetesSlave kubernetesSlave) {
        this.kubernetesSlave = kubernetesSlave;
    }

    public static class JenkinsPodSlaveDeploymentContextBuilder {
        private Label jobLabel;
        private List<PodSlaveConfigurationParams> podConfigurations;
        private KubernetesCloud kubernetesCloud;
        private String deploymentNamespace;

        public JenkinsPodSlaveDeploymentContextBuilder withJobLabel(Label label) {
            this.jobLabel = label;
            return this;
        }

        public JenkinsPodSlaveDeploymentContextBuilder withOneOfThesePodConfigurations(List<PodSlaveConfigurationParams> podConfigurations) {
            this.podConfigurations = podConfigurations;
            return this;
        }

        public JenkinsPodSlaveDeploymentContextBuilder intoKubernetesCloud(KubernetesCloud kubernetesCloud) {
            this.kubernetesCloud = kubernetesCloud;
            return this;
        }

        public JenkinsPodSlaveDeploymentContextBuilder withNamespace(String deploymentNamespace) {
            this.deploymentNamespace = deploymentNamespace;
            return this;
        }

        public PodDeploymentContext build() {
            return new PodDeploymentContext(this);
        }
    }
}

