/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api.charts.github;

import com.elasticbox.jenkins.k8s.auth.Authentication;
import com.elasticbox.jenkins.k8s.auth.TokenAuthentication;
import com.elasticbox.jenkins.k8s.auth.UserAndPasswordAuthentication;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApiResponseContentType;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApiType;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubClient;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubClientsFactory;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hudson.Extension;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

@Extension
public class GitHubClientsFactoryImpl
implements GitHubClientsFactory {
    private static final Logger LOGGER = Logger.getLogger(GitHubClientsFactoryImpl.class.getName());
    public static final int MAX_NUM_GITHUB_CLIENTS_CACHED = 100;
    public static final int CACHED_HOURS = 24;
    private LoadingCache<ClientsFactoryBuilderContext, GitHubClient> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(24L, TimeUnit.HOURS).build((CacheLoader)new GithubClientCacheLoader());
    private static GitHubClientsFactoryPartBuilder[] partBuilders = new GitHubClientsFactoryPartBuilder[]{new AddBaseUrl(), new AddResponseConverters(), new AddAuthenticationTokenInterceptor(), new AddClientAndPasswordAuthenticationInterceptor(), new AddLoggingInterceptor()};

    @Override
    public <T> T getClient(String baseUrl, Authentication authentication, Class<T> serviceTypeInterface, GitHubApiResponseContentType responseType) throws RepositoryException {
        GitHubClient client;
        String apiBaseUrl = GitHubApiType.findOrComposeApiBaseUrl(baseUrl);
        ClientsFactoryBuilderContext<T> context = new ClientsFactoryBuilderContext<T>(apiBaseUrl, serviceTypeInterface, responseType, authentication);
        try {
            client = (GitHubClient)this.cache.get(context);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "Error getting the GitHub client object", e);
            throw new RepositoryException(e);
        }
        return client.getClient();
    }

    @Override
    public <T> T getClient(String baseUrl, Class<T> serviceTypeInterface, GitHubApiResponseContentType responseType) throws RepositoryException {
        GitHubClient client;
        String apiBaseUrl = GitHubApiType.findOrComposeApiBaseUrl(baseUrl);
        ClientsFactoryBuilderContext<T> context = new ClientsFactoryBuilderContext<T>(apiBaseUrl, serviceTypeInterface, responseType);
        try {
            client = (GitHubClient)this.cache.get(context);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "Error getting the GitHub client object", e);
            throw new RepositoryException(e);
        }
        return client.getClient();
    }

    LoadingCache<ClientsFactoryBuilderContext, GitHubClient> getCache() {
        return this.cache;
    }

    private static class GithubClientCacheLoader
    extends CacheLoader<ClientsFactoryBuilderContext, GitHubClient> {
        private GithubClientCacheLoader() {
        }

        public GitHubClient load(ClientsFactoryBuilderContext context) throws Exception {
            for (GitHubClientsFactoryPartBuilder partBuilder : partBuilders) {
                partBuilder.buildPart(context);
            }
            Retrofit.Builder clientBuilder = context.getClientBuilder();
            if (context.getOkHttpClientBuilder() != null) {
                OkHttpClient.Builder okHttpClientBuilder = context.getOkHttpClientBuilder();
                OkHttpClient okHttpClient = okHttpClientBuilder.build();
                clientBuilder = clientBuilder.client(okHttpClient);
            }
            return new GitHubClient<Object>(context.getApiBaseUrl(), clientBuilder.addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build().create(context.getServiceTypeInterfaceClass()));
        }
    }

    private static class AddClientAndPasswordAuthenticationInterceptor
    implements GitHubClientsFactoryPartBuilder {
        public static final String BASIC_AUTH_TOKEN = "Basic";
        public static final String BASIC_AUTH_HEADER = "Authorization";

        private AddClientAndPasswordAuthenticationInterceptor() {
        }

        @Override
        public void buildPart(ClientsFactoryBuilderContext context) {
            Authentication authentication;
            if (context.isAtLeastOneAuthenticationMethodProvided()) {
                return;
            }
            if (context.getAuthentication() != null && (authentication = context.getAuthentication()) instanceof UserAndPasswordAuthentication) {
                UserAndPasswordAuthentication authenticationMethod = (UserAndPasswordAuthentication)authentication;
                String username = authenticationMethod.getUser();
                String password = authenticationMethod.getPassword();
                if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                    String credentials = username + ":" + password;
                    final String basic = "Basic " + new Base64().encodeToString(credentials.getBytes(Charset.forName("UTF-8")));
                    OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            Request request = chain.request().newBuilder().addHeader(AddClientAndPasswordAuthenticationInterceptor.BASIC_AUTH_HEADER, basic).build();
                            Response response = chain.proceed(request);
                            return response;
                        }
                    });
                    context.setOkHttpClientBuilder(okBuilder);
                    context.setAtLeastOneAuthenticationMethodProvided(true);
                }
            }
        }
    }

    private static class AddLoggingInterceptor
    implements GitHubClientsFactoryPartBuilder {
        private AddLoggingInterceptor() {
        }

        @Override
        public void buildPart(ClientsFactoryBuilderContext context) {
            if (context.isDebug()) {
                if (context.getOkHttpClientBuilder() == null) {
                    OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
                    context.setOkHttpClientBuilder(httpClient);
                }
                OkHttpClient.Builder okHttpClientBuilder = context.getOkHttpClientBuilder();
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                okHttpClientBuilder.addInterceptor((Interceptor)logging);
            }
        }
    }

    private static class AddAuthenticationTokenInterceptor
    implements GitHubClientsFactoryPartBuilder {
        public static final String TOKEN = "token";
        public static final String BASIC_AUTH_HEADER = "Authorization";

        private AddAuthenticationTokenInterceptor() {
        }

        @Override
        public void buildPart(ClientsFactoryBuilderContext context) {
            TokenAuthentication authenticationMethod;
            String token;
            Authentication authentication;
            if (context.isAtLeastOneAuthenticationMethodProvided()) {
                return;
            }
            if (context.getAuthentication() != null && (authentication = context.getAuthentication()) instanceof TokenAuthentication && StringUtils.isNotBlank((String)(token = (authenticationMethod = (TokenAuthentication)authentication).getAuthToken()))) {
                final String basic = "token " + token;
                OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        Request request = chain.request().newBuilder().addHeader(AddAuthenticationTokenInterceptor.BASIC_AUTH_HEADER, basic).build();
                        Response response = chain.proceed(request);
                        return response;
                    }
                });
                context.setOkHttpClientBuilder(okBuilder);
                context.setAtLeastOneAuthenticationMethodProvided(true);
            }
        }
    }

    private static class AddResponseConverters
    implements GitHubClientsFactoryPartBuilder {
        private AddResponseConverters() {
        }

        @Override
        public void buildPart(ClientsFactoryBuilderContext context) {
            GitHubApiResponseContentType responseContentType = context.getResponseContentType();
            switch (responseContentType) {
                case JSON: {
                    context.getClientBuilder().addConverterFactory((Converter.Factory)GsonConverterFactory.create());
                    break;
                }
                case RAW_STRING: {
                    context.getClientBuilder().addConverterFactory((Converter.Factory)ScalarsConverterFactory.create());
                    break;
                }
            }
        }
    }

    private static class AddBaseUrl
    implements GitHubClientsFactoryPartBuilder {
        private AddBaseUrl() {
        }

        @Override
        public void buildPart(ClientsFactoryBuilderContext context) {
            String apiBaseUrl = context.getApiBaseUrl();
            context.getClientBuilder().baseUrl(apiBaseUrl);
        }
    }

    public static interface GitHubClientsFactoryPartBuilder {
        public void buildPart(ClientsFactoryBuilderContext var1);
    }

    private static class ClientsFactoryBuilderContext<T> {
        private Class<T> serviceTypeInterfaceClass;
        private String apiBaseUrl;
        private GitHubApiResponseContentType responseContentType;
        private Authentication authentication;
        private boolean debug = false;
        private Retrofit.Builder clientBuilder = new Retrofit.Builder();
        private OkHttpClient.Builder okHttpClientBuilder;
        private boolean atLeastOneAuthenticationMethodProvided = false;

        public ClientsFactoryBuilderContext(String apiBaseUrl, Class<T> serviceTypeInterfaceClass, GitHubApiResponseContentType responseContentType) {
            this.apiBaseUrl = apiBaseUrl;
            this.serviceTypeInterfaceClass = serviceTypeInterfaceClass;
            this.responseContentType = responseContentType;
        }

        public ClientsFactoryBuilderContext(String apiBaseUrl, Class<T> serviceTypeInterfaceClass, GitHubApiResponseContentType responseContentType, Authentication authentication) {
            this.apiBaseUrl = apiBaseUrl;
            this.serviceTypeInterfaceClass = serviceTypeInterfaceClass;
            this.responseContentType = responseContentType;
            this.authentication = authentication;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public Class<T> getServiceTypeInterfaceClass() {
            return this.serviceTypeInterfaceClass;
        }

        public GitHubApiResponseContentType getResponseContentType() {
            return this.responseContentType;
        }

        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }

        public OkHttpClient.Builder getOkHttpClientBuilder() {
            return this.okHttpClientBuilder;
        }

        public void setOkHttpClientBuilder(OkHttpClient.Builder okHttpClientBuilder) {
            this.okHttpClientBuilder = okHttpClientBuilder;
        }

        public Retrofit.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        public void setClientBuilder(Retrofit.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
        }

        public boolean isAtLeastOneAuthenticationMethodProvided() {
            return this.atLeastOneAuthenticationMethodProvided;
        }

        public void setAtLeastOneAuthenticationMethodProvided(boolean atLeastOneAuthenticationMethodProvided) {
            this.atLeastOneAuthenticationMethodProvided = atLeastOneAuthenticationMethodProvided;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ClientsFactoryBuilderContext that = (ClientsFactoryBuilderContext)object;
            if (this.debug != that.debug) {
                return false;
            }
            if (this.serviceTypeInterfaceClass != null ? !this.serviceTypeInterfaceClass.equals(that.serviceTypeInterfaceClass) : that.serviceTypeInterfaceClass != null) {
                return false;
            }
            if (this.apiBaseUrl != null ? !this.apiBaseUrl.equals(that.apiBaseUrl) : that.apiBaseUrl != null) {
                return false;
            }
            if (this.responseContentType != that.responseContentType) {
                return false;
            }
            return !(this.authentication == null ? that.authentication != null : !this.authentication.equals(that.authentication));
        }

        public int hashCode() {
            int result = this.serviceTypeInterfaceClass != null ? this.serviceTypeInterfaceClass.hashCode() : 0;
            result = 31 * result + (this.apiBaseUrl != null ? this.apiBaseUrl.hashCode() : 0);
            result = 31 * result + (this.responseContentType != null ? this.responseContentType.hashCode() : 0);
            result = 31 * result + (this.authentication != null ? this.authentication.hashCode() : 0);
            result = 31 * result + (this.debug ? 1 : 0);
            return result;
        }
    }
}

