/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api.charts.github;

import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApi;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubUrl;
import java.text.MessageFormat;
import java.util.EnumSet;

public enum GitHubApiType implements GitHubApi
{
    PUBLIC_API{

        @Override
        public boolean isApplicableFor(GitHubUrl url) {
            return this.getUrlType().endsWith(url.host() + "/");
        }

        @Override
        public String getUrlType() {
            return "https://api.github.com/";
        }
    }
    ,
    PUBLIC_RAW_CONTENT{

        @Override
        public boolean isApplicableFor(GitHubUrl url) {
            return this.getUrlType().equals(url.protocol() + "://" + url.host() + "/");
        }

        @Override
        public String getUrlType() {
            return "https://raw.githubusercontent.com/";
        }
    }
    ,
    ENTERPRISE_RAW{

        @Override
        public boolean isApplicableFor(GitHubUrl url) {
            String[] pathTokens = url.pathAsArray();
            return pathTokens[0].equals("raw");
        }

        @Override
        public String getUrlType() {
            return "{0}raw/";
        }
    }
    ,
    ENTERPRISE{

        @Override
        public boolean isApplicableFor(GitHubUrl url) {
            return false;
        }

        @Override
        public String getUrlType() {
            return "{0}api/v3/";
        }
    };


    public static String findOrComposeApiBaseUrl(String url) {
        GitHubUrl gitHubUrl = new GitHubUrl(url);
        GitHubApiType apiType = GitHubApiType.findBy(gitHubUrl);
        return GitHubApiType.findOrComposeApiBaseUrl(apiType, gitHubUrl);
    }

    private static String findOrComposeApiBaseUrl(GitHubApiType gitHubApiType, GitHubUrl url) {
        switch (gitHubApiType) {
            case PUBLIC_API: {
                return PUBLIC_API.getUrlType();
            }
            case PUBLIC_RAW_CONTENT: {
                return PUBLIC_RAW_CONTENT.getUrlType();
            }
            case ENTERPRISE_RAW: {
                return MessageFormat.format(ENTERPRISE_RAW.getUrlType(), url.getHostAndPortTogether());
            }
        }
        return MessageFormat.format(ENTERPRISE.getUrlType(), url.getHostAndPortTogether());
    }

    public static GitHubApiType findBy(GitHubUrl url) {
        EnumSet<GitHubApiType> apiSet = EnumSet.of(PUBLIC_API, PUBLIC_RAW_CONTENT, ENTERPRISE_RAW, ENTERPRISE);
        for (GitHubApiType gitHubApiType : apiSet) {
            if (!gitHubApiType.isApplicableFor(url)) continue;
            return gitHubApiType;
        }
        return ENTERPRISE;
    }
}

