/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api.charts.factory;

import com.elasticbox.jenkins.k8s.chart.Chart;
import com.elasticbox.jenkins.k8s.repositories.api.charts.factory.ManifestType;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;

public class ManifestFactory {
    public static void addManifest(String yamlAsText, Chart.ChartBuilder chartBuilder) throws RepositoryException {
        String manifestKind = ManifestFactory.findManifestKind(yamlAsText);
        ManifestType type = ManifestType.findByType(manifestKind);
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        InputStream inputStream = IOUtils.toInputStream((String)yamlAsText);
        switch (type) {
            case POD: {
                Pod pod = (Pod)((ClientPodResource)client.pods().load((Object)inputStream)).get();
                chartBuilder.addPod(pod);
                return;
            }
            case REPLICATION_CONTROLLER: {
                ReplicationController replicationController = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().load((Object)inputStream)).get();
                chartBuilder.addReplicationController(replicationController);
                return;
            }
            case SERVICE: {
                Service service = (Service)((ClientResource)client.services().load((Object)inputStream)).get();
                chartBuilder.addService(service);
                return;
            }
        }
        throw new RepositoryException("Manifest kind: " + manifestKind + " is not supported");
    }

    private static String findManifestKind(String yamlAsText) {
        Yaml yaml = new Yaml();
        StringReader stringReader = new StringReader(yamlAsText);
        Iterable parse = yaml.parse((Reader)stringReader);
        boolean kindFound = false;
        int countBetween = 0;
        String kind = null;
        for (Event event : parse) {
            if (kindFound) {
                ++countBetween;
            }
            if (!event.is(Event.ID.Scalar)) continue;
            ScalarEvent scalarEvent = (ScalarEvent)event;
            String value = scalarEvent.getValue();
            if (countBetween == 1) {
                kind = value;
                break;
            }
            if (!value.equals("kind")) continue;
            kindFound = true;
        }
        return kind;
    }
}

