/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api.charts;

import com.elasticbox.jenkins.k8s.chart.Chart;
import com.elasticbox.jenkins.k8s.chart.ChartDetails;
import com.elasticbox.jenkins.k8s.chart.ChartRepo;
import com.elasticbox.jenkins.k8s.repositories.ChartRepository;
import com.elasticbox.jenkins.k8s.repositories.api.charts.factory.ManifestFactory;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApiContentsService;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApiRawContentDownloadService;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubApiResponseContentType;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubClientsFactory;
import com.elasticbox.jenkins.k8s.repositories.api.charts.github.GitHubContent;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.google.inject.Inject;
import hudson.Extension;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.Yaml;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;

@Extension
public class ChartRepositoryApiImpl
implements ChartRepository {
    @Inject
    GitHubClientsFactory clientsFactory;

    @Override
    public List<String> chartNames(ChartRepo repo) throws RepositoryException {
        return this.chartNames(repo, null);
    }

    @Override
    public List<String> chartNames(ChartRepo repo, String ref) throws RepositoryException {
        final ArrayList<String> chartNames = new ArrayList<String>();
        String defaultRef = ref == null || ref.equals("") ? "master" : ref;
        GitHubApiContentsService client = this.getClient(repo, repo.getUrl().toString(), GitHubApiContentsService.class, GitHubApiResponseContentType.JSON);
        client.content(repo.getUrl().ownerInCaseOfRepoUrl(), repo.getUrl().repoInCaseOfRepoUrl(), "", defaultRef).flatMap((Func1)new Func1<List<GitHubContent>, Observable<GitHubContent>>(){

            public Observable<GitHubContent> call(List<GitHubContent> gitHubContents) {
                return Observable.from(gitHubContents);
            }
        }).filter((Func1)new Func1<GitHubContent, Boolean>(){

            public Boolean call(GitHubContent gitHubContent) {
                return gitHubContent.getType().equals("dir");
            }
        }).subscribe((Action1)new Action1<GitHubContent>(){

            public void call(GitHubContent gitHubContent) {
                chartNames.add(gitHubContent.getName());
            }
        });
        return chartNames;
    }

    @Override
    public Chart chart(ChartRepo repo, String chartName) throws RepositoryException {
        return this.chart(repo, chartName, null);
    }

    @Override
    public Chart chart(final ChartRepo repo, String chartName, String ref) throws RepositoryException {
        final Chart.ChartBuilder chartBuilder = new Chart.ChartBuilder();
        String defaultRef = ref == null || ref.equals("") ? "master" : ref;
        GitHubApiContentsService client = this.getClient(repo, repo.getUrl().toString(), GitHubApiContentsService.class, GitHubApiResponseContentType.JSON);
        client.content(repo.getUrl().ownerInCaseOfRepoUrl(), repo.getUrl().repoInCaseOfRepoUrl(), chartName, defaultRef).flatMap((Func1)new Func1<List<GitHubContent>, Observable<GitHubContent>>(){

            public Observable<GitHubContent> call(List<GitHubContent> gitHubContents) {
                return Observable.from(gitHubContents);
            }
        }).subscribe((Action1)new Action1<GitHubContent>(){

            public void call(GitHubContent gitHubContent) {
                if (gitHubContent.getName().equals("Chart.yaml")) {
                    String chartUrl = gitHubContent.getDownloadUrl();
                    try {
                        ChartRepositoryApiImpl.this.chartDetails(repo, chartUrl, chartBuilder);
                    }
                    catch (RepositoryException e) {
                        Exceptions.propagate((Throwable)e);
                    }
                } else if (gitHubContent.getType().equals("dir") && gitHubContent.getName().equals("manifests")) {
                    try {
                        ChartRepositoryApiImpl.this.manifests(repo, gitHubContent.getUrl(), chartBuilder);
                    }
                    catch (RepositoryException e) {
                        Exceptions.propagate((Throwable)e);
                    }
                }
            }
        });
        return chartBuilder.build();
    }

    private void manifests(final ChartRepo repo, String manifestsListUrl, final Chart.ChartBuilder chartBuilder) throws RepositoryException {
        GitHubApiContentsService client = this.getClient(repo, manifestsListUrl, GitHubApiContentsService.class, GitHubApiResponseContentType.JSON);
        client.content(manifestsListUrl).flatMap((Func1)new Func1<List<GitHubContent>, Observable<GitHubContent>>(){

            public Observable<GitHubContent> call(List<GitHubContent> gitHubContents) {
                return Observable.from(gitHubContents);
            }
        }).subscribe((Action1)new Action1<GitHubContent>(){

            public void call(GitHubContent gitHubContent) {
                String manifestUrl = gitHubContent.getDownloadUrl();
                try {
                    ChartRepositoryApiImpl.this.manifest(repo, manifestUrl, chartBuilder);
                }
                catch (RepositoryException e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    private void manifest(ChartRepo repo, String manifestContentUrl, final Chart.ChartBuilder chartBuilder) throws RepositoryException {
        GitHubApiRawContentDownloadService client = this.getClient(repo, manifestContentUrl, GitHubApiRawContentDownloadService.class, GitHubApiResponseContentType.RAW_STRING);
        client.rawContent(manifestContentUrl).subscribe((Action1)new Action1<String>(){

            public void call(String yaml) {
                try {
                    ManifestFactory.addManifest(yaml, chartBuilder);
                }
                catch (RepositoryException e) {
                    chartBuilder.addError(e);
                }
            }
        });
    }

    private <T> void chartDetails(ChartRepo repo, String chartDetailsContentUrl, final Chart.ChartBuilder chartBuilder) throws RepositoryException {
        GitHubApiRawContentDownloadService client = this.getClient(repo, chartDetailsContentUrl, GitHubApiRawContentDownloadService.class, GitHubApiResponseContentType.RAW_STRING);
        final Yaml yaml = new Yaml();
        client.rawContent(chartDetailsContentUrl).map((Func1)new Func1<String, ChartDetails>(){

            public ChartDetails call(String yamlString) {
                ChartDetails chartDetails = (ChartDetails)yaml.loadAs(yamlString, ChartDetails.class);
                return chartDetails;
            }
        }).subscribe((Action1)new Action1<ChartDetails>(){

            public void call(ChartDetails details) {
                chartBuilder.chartDetails(details);
            }
        });
    }

    private <T> T getClient(ChartRepo repo, String url, Class<T> serviceClass, GitHubApiResponseContentType resType) throws RepositoryException {
        T client = null;
        client = repo.needsAuthentication() ? (T)this.clientsFactory.getClient(url, repo.getAuthentication(), serviceClass, resType) : (T)this.clientsFactory.getClient(url, serviceClass, resType);
        return client;
    }

    public GitHubClientsFactory getClientsFactory() {
        return this.clientsFactory;
    }

    public void setClientsFactory(GitHubClientsFactory clientsFactory) {
        this.clientsFactory = clientsFactory;
    }
}

