/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.slaves;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesComputer;
import com.elasticbox.jenkins.k8s.plugin.slaves.SingleUseRetentionStrategy;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KubernetesSlave
extends AbstractCloudSlave {
    public static final String DEFAULT_REMOTE_FS = "/home/jenkins";
    public static final String DESCRIPTION = "Jenkins Kubernetes Slave";
    private static final int IDLE_MINUTES = 1;
    private static final int EXECUTORS = 1;
    private static final Logger LOGGER = Logger.getLogger(KubernetesSlave.class.getName());
    private static final long serialVersionUID = -8642936855413034232L;
    private final transient KubernetesCloud kubernetesCloud;
    private final transient PodRepository podRepository;

    public KubernetesSlave(String podName, PodRepository podRepository, KubernetesCloud kubernetesCloud, Label label) throws Descriptor.FormException, IOException {
        super(podName, DESCRIPTION, DEFAULT_REMOTE_FS, 1, Node.Mode.NORMAL, label == null ? null : label.toString(), (ComputerLauncher)new JNLPLauncher(), (RetentionStrategy)new SingleUseRetentionStrategy(1), Collections.emptyList());
        this.kubernetesCloud = kubernetesCloud;
        this.podRepository = podRepository;
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        LOGGER.info("Terminating Kubernetes instance for slave: " + this.name);
        Computer computer = this.toComputer();
        if (computer != null && computer.isOnline()) {
            try {
                this.podRepository.delete(this.kubernetesCloud.getName(), this.kubernetesCloud.getNamespace(), this.name);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Terminated Kubernetes instance for slave: " + this.name);
                }
                return;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failure to terminate instance for slave: " + this.name, exception);
            }
        }
        LOGGER.warning("There is no computer for slave: " + this.name);
    }

    public KubernetesComputer createComputer() {
        return new KubernetesComputer(this);
    }

    public String toString() {
        return String.format("KubernetesSlave name: %s", this.name);
    }
}

