/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.builders;

import com.elasticbox.jenkins.k8s.chart.Chart;
import com.elasticbox.jenkins.k8s.chart.ChartRepo;
import com.elasticbox.jenkins.k8s.plugin.builders.BaseChartBuildStep;
import com.elasticbox.jenkins.k8s.plugin.builders.ChartBuildStepDescriptor;
import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.repositories.ChartRepository;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.util.TaskLogger;
import com.google.inject.Inject;
import com.google.inject.Injector;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployChartBuildStep
extends BaseChartBuildStep {
    private static final Logger LOGGER = Logger.getLogger(DeployChartBuildStep.class.getName());
    private static final String NAME_PREFIX = "DeployChartBS-";
    private static final String KUBERNETES_DEPLOY_CHART = "Kubernetes - Deploy Chart";
    private static final String JENKINS_JOB = "elastickube.com/jenkins-build";
    private final boolean deleteChartWhenFinished;

    @DataBoundConstructor
    public DeployChartBuildStep(String id, String kubeName, String chartsRepo, String chartName, boolean deleteChartWhenFinished) {
        this.id = StringUtils.isNotEmpty((String)id) ? id : NAME_PREFIX + UUID.randomUUID().toString();
        this.kubeName = kubeName;
        this.chartsRepo = chartsRepo;
        this.chartName = chartName;
        this.deleteChartWhenFinished = deleteChartWhenFinished;
        this.injectMembers();
    }

    public boolean getDeleteChartWhenFinished() {
        return this.deleteChartWhenFinished;
    }

    @Override
    protected void doPerform(Run<?, ?> run, TaskLogger taskLogger, KubernetesCloud kubeCloud, ChartRepo chartRepo) throws ServiceException {
        taskLogger.info("Deploying chart: " + this.getChartName());
        String namespace = kubeCloud.getNamespace();
        String runName = run != null ? run.toString() : "<NO-RUN>";
        Map<String, String> label = Collections.singletonMap(JENKINS_JOB, StringUtils.deleteWhitespace((String)runName).replace('#', '_'));
        Chart chart = this.deploymentService.deployChart(this.getKubeName(), namespace, chartRepo, this.chartName, label);
        taskLogger.info("Chart [" + this.chartName + "] deployed");
        if (this.deleteChartWhenFinished && run instanceof FreeStyleBuild) {
            taskLogger.info("Chart [" + this.chartName + "] will be deleted at the end of the run");
            DeployChartCleanup chartCleanup = new DeployChartCleanup(this, namespace, chart, taskLogger);
            ((FreeStyleBuild)run).getEnvironments().add(0, (Environment)chartCleanup);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ChartBuildStepDescriptor {
        public DescriptorImpl() {
            super(DeployChartBuildStep.class, DeployChartBuildStep.KUBERNETES_DEPLOY_CHART);
            LOGGER.warning("No args constructor called. No injection performed!");
        }

        @Inject
        public DescriptorImpl(Injector injector, ChartRepository chartRepository) {
            super(DeployChartBuildStep.class, injector, chartRepository, DeployChartBuildStep.KUBERNETES_DEPLOY_CHART);
        }
    }

    public static class DeployChartCleanup
    extends Environment {
        DeployChartBuildStep deployer;
        String namespace;
        Chart chart;
        TaskLogger taskLogger;

        public DeployChartCleanup() {
            LOGGER.warning("Called no-argument constructor. No cleanup will be performed.");
        }

        public DeployChartCleanup(DeployChartBuildStep deployer, String namespace, Chart chart, TaskLogger taskLogger) {
            this.deployer = deployer;
            this.namespace = namespace;
            this.chart = chart;
            this.taskLogger = taskLogger;
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.chart == null) {
                return true;
            }
            try {
                this.deployer.deploymentService.deleteChart(this.deployer.getKubeName(), this.namespace, this.chart);
                this.taskLogger.info("Chart [" + this.chart.getName() + "] successfully removed");
            }
            catch (ServiceException excep) {
                this.taskLogger.error("Error while cleaning up chart [" + this.chart.getName() + "]: " + excep + ". Initial cause: " + excep.getCausedByMessages());
            }
            return true;
        }
    }
}

