/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.builders;

import com.elasticbox.jenkins.k8s.chart.ChartRepo;
import com.elasticbox.jenkins.k8s.plugin.builders.BaseChartBuildStep;
import com.elasticbox.jenkins.k8s.plugin.builders.ChartBuildStepDescriptor;
import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.repositories.ChartRepository;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.util.TaskLogger;
import com.google.inject.Inject;
import com.google.inject.Injector;
import hudson.Extension;
import hudson.model.Run;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeleteChartBuildStep
extends BaseChartBuildStep {
    private static final Logger LOGGER = Logger.getLogger(DeleteChartBuildStep.class.getName());
    private static final String NAME_PREFIX = "DeleteChartBS-";
    private static final String KUBERNETES_DELETE_CHART = "Kubernetes - Delete Chart";

    @DataBoundConstructor
    public DeleteChartBuildStep(String id, String kubeName, String chartsRepo, String chartName) {
        this.id = StringUtils.isNotEmpty((String)id) ? id : NAME_PREFIX + UUID.randomUUID().toString();
        this.kubeName = kubeName;
        this.chartsRepo = chartsRepo;
        this.chartName = chartName;
        this.injectMembers();
    }

    @Override
    protected void doPerform(Run<?, ?> run, TaskLogger taskLogger, KubernetesCloud kubeCloud, ChartRepo chartRepo) throws ServiceException {
        taskLogger.info("Deleting chart: " + this.getChartName());
        this.deploymentService.deleteChart(this.getKubeName(), kubeCloud.getNamespace(), chartRepo, this.getChartName());
        taskLogger.info("Chart [" + this.getChartName() + "] deleted");
    }

    @Extension
    public static final class DescriptorImpl
    extends ChartBuildStepDescriptor {
        public DescriptorImpl() {
            super(DeleteChartBuildStep.class, DeleteChartBuildStep.KUBERNETES_DELETE_CHART);
            LOGGER.warning("No args constructor called. No injection performed!");
        }

        @Inject
        public DescriptorImpl(Injector injector, ChartRepository chartRepository) {
            super(DeleteChartBuildStep.class, injector, chartRepository, DeleteChartBuildStep.KUBERNETES_DELETE_CHART);
        }
    }
}

