/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.chart;

import com.elasticbox.jenkins.k8s.chart.ChartDetails;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import java.util.ArrayList;
import java.util.List;

public class Chart {
    private String details;
    private String name;
    private String home;
    private String source;
    private String version;
    private String description;
    private List<String> maintainers;
    private List<Service> services;
    private List<ReplicationController> replicationControllers;
    private List<Pod> pods;

    private Chart(ChartBuilder builder) {
        this.details = builder.chartDetails.getDetails();
        this.name = builder.chartDetails.getName();
        this.home = builder.chartDetails.getHome();
        this.source = builder.chartDetails.getSource();
        this.version = builder.chartDetails.getVersion();
        this.description = builder.chartDetails.getDescription();
        this.maintainers = builder.chartDetails.getMaintainers();
        this.pods = builder.pods;
        this.replicationControllers = builder.replicationControllers;
        this.services = builder.services;
    }

    public String getDetails() {
        return this.details;
    }

    public String getName() {
        return this.name;
    }

    public String getHome() {
        return this.home;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getMaintainers() {
        return this.maintainers;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public List<ReplicationController> getReplicationControllers() {
        return this.replicationControllers;
    }

    public List<Pod> getPods() {
        return this.pods;
    }

    public static class ChartBuilder {
        private List<RepositoryException> errors = new ArrayList<RepositoryException>();
        ChartDetails chartDetails;
        private List<Service> services = new ArrayList<Service>();
        private List<ReplicationController> replicationControllers = new ArrayList<ReplicationController>();
        private List<Pod> pods = new ArrayList<Pod>();

        public ChartBuilder chartDetails(ChartDetails details) {
            this.chartDetails = details;
            return this;
        }

        public ChartBuilder addService(Service service) {
            this.services.add(service);
            return this;
        }

        public ChartBuilder addPod(Pod pod) {
            this.pods.add(pod);
            return this;
        }

        public ChartBuilder addReplicationController(ReplicationController controller) {
            this.replicationControllers.add(controller);
            return this;
        }

        public Chart build() throws RepositoryException {
            if (this.errors.isEmpty()) {
                return new Chart(this);
            }
            throw this.errors.get(0);
        }

        public ChartBuilder addError(RepositoryException exception) {
            this.errors.add(exception);
            return this;
        }
    }
}

