/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import hudson.util.Secret;
import java.util.List;
import java.util.Optional;
import org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials;
import org.jenkinsci.plugins.github_branch_source.app_credentials.AccessSpecifiedRepositories;
import org.jenkinsci.plugins.github_branch_source.app_credentials.RepositoryAccessStrategy;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"github-branch-source"})
public class GitHubAppCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "gitHubApp".equals(type);
    }

    public GitHubAppCredentials convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "gitHubApp definition contains no data");
        String appIDBase64 = SecretUtils.getNonNullSecretData(secret, "appID", "gitHubApp credential is missing the appID");
        String privateKeyBase64 = SecretUtils.getNonNullSecretData(secret, "privateKey", "gitHubApp credential is missing the privateKey");
        Optional<String> ownerBase64 = SecretUtils.getOptionalSecretData(secret, "owner", "gitHubApp credential is missing the owner");
        String appID = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(appIDBase64), "gitHubApp credential has an invalid appID (must be base64 encoded UTF-8)");
        Optional<String> apiUriBase64 = SecretUtils.getOptionalSecretData(secret, "apiUri", "gitHubApp credential is missing the apiUri");
        String privateKey = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(privateKeyBase64), "gitHubApp credential has an invalid privateKey (must be base64 encoded data)");
        Secret privateKeySecret = Secret.fromString((String)privateKey);
        GitHubAppCredentials credentials = new GitHubAppCredentials(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), appID, privateKeySecret);
        if (ownerBase64.isPresent()) {
            String owner = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(ownerBase64.get()), "gitHubApp credential has an invalid owner (must be base64 encoded data)");
            credentials.setRepositoryAccessStrategy((RepositoryAccessStrategy)new AccessSpecifiedRepositories(owner, List.of()));
        }
        if (apiUriBase64.isPresent()) {
            String apiUri = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(apiUriBase64.get()), "gitHubApp credential has an invalid apiUri (must be base64 encoded data)");
            credentials.setApiUri(apiUri);
        }
        return credentials;
    }
}

