/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Builder;
import com.cloudbees.groovy.cps.CatchExpression;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.LValueBlock;
import com.cloudbees.groovy.cps.MethodLocation;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.CpsCallable;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.CpsFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class BasicTest {
    Builder b = new Builder(MethodLocation.UNKNOWN);
    Block $x = this.b.localVariable("x");
    Block $y = this.b.localVariable("y");
    Block $z = this.b.localVariable("z");

    private Object run(Block ... bodies) {
        try {
            Env e = Envs.empty();
            Next p = new Next(this.b.block(bodies), e, Continuation.HALT);
            return p.run().yield.wrapReplay();
        }
        catch (InvocationTargetException x) {
            throw new AssertionError((Object)x);
        }
    }

    @Test
    public void constant() {
        Assert.assertEquals((Object)3, (Object)this.run(this.b.constant((Object)3)));
    }

    @Test
    public void onePlusOne() {
        Assert.assertEquals((Object)true, (Object)this.run(this.b.staticCall(0, ScriptBytecodeAdapter.class, "compareEqual", new Block[]{this.b.one(), this.b.one()})));
    }

    @Test
    public void variable() {
        Assert.assertEquals((Object)3, (Object)this.run(this.b.setLocalVariable(0, "x", this.b.one()), this.b.setLocalVariable(0, "y", this.b.two()), this.b.plus(0, this.$x, this.$y)));
    }

    @Test
    public void forLoop() {
        Assert.assertEquals((Object)45, (Object)this.run(new Block[]{this.b.setLocalVariable(0, "sum", this.b.zero()), this.b.forLoop(null, this.b.setLocalVariable(0, "x", this.b.zero()), this.b.lessThan(0, this.$x, this.b.constant((Object)10)), this.b.localVariableAssignOp(0, "x", "plus", this.b.one()), this.b.block(new Block[]{this.b.localVariableAssignOp(0, "sum", "plus", this.$x)})), this.b.localVariable("sum")}));
    }

    @Test
    public void returnStatement() {
        Assert.assertEquals((Object)0, (Object)this.run(this.b.setLocalVariable(0, "x", this.b.zero()), this.b.return_(this.$x), this.b.localVariableAssignOp(0, "x", "plus", this.b.one()), this.b.plus(0, this.$x, this.$y)));
    }

    @Test
    public void ifTrue() {
        this.if_(true, 1);
        this.if_(false, 2);
    }

    private void if_(boolean cond, int expected) {
        Assert.assertEquals((Object)expected, (Object)this.run(this.b.setLocalVariable(0, "x", this.b.zero()), this.b.if_(this.b.constant((Object)cond), this.b.setLocalVariable(0, "x", this.b.one()), this.b.setLocalVariable(0, "x", this.b.two())), this.$x));
    }

    @Test
    public void asyncCallingAsync() {
        class Op {
            Op() {
            }

            public int add(int x, int y) {
                CpsFunction f = new CpsFunction(List.of("x", "y"), BasicTest.this.b.sequence(BasicTest.this.b.setLocalVariable(0, "z", BasicTest.this.b.functionCall(0, BasicTest.this.$x, "plus", new Block[]{BasicTest.this.$y})), BasicTest.this.b.return_(BasicTest.this.$z)));
                throw new CpsCallableInvocation((CpsCallable)f, (Object)this, new Object[]{x, y});
            }
        }
        Assert.assertEquals((Object)3, (Object)this.run(this.b.setLocalVariable(0, "z", this.b.zero()), this.b.plus(0, this.b.functionCall(0, this.b.constant((Object)new Op()), "add", new Block[]{this.b.one(), this.b.two()}), this.$z)));
    }

    @Test
    public void newInstance() {
        InstantiationTest v = (InstantiationTest)this.run(this.b.new_(0, InstantiationTest.class, new Block[]{this.b.constant((Object)3)}));
        Assert.assertEquals((long)3L, (long)v.v);
        v = (InstantiationTest)this.run(this.b.new_(0, InstantiationTest.class, new Block[]{this.b.constant((Object)3), this.b.constant((Object)4)}));
        Assert.assertEquals((long)7L, (long)v.v);
    }

    @Test
    public void localExceptionHandling() {
        Assert.assertEquals((Object)"foo", (Object)this.run(this.b.tryCatch(this.b.sequence(this.b.throw_(0, this.b.new_(0, RuntimeException.class, new Block[]{this.b.constant((Object)"foo")})), this.b.return_(this.b.null_())), null, new CatchExpression[]{new CatchExpression(Exception.class, "e", this.b.block(new Block[]{this.b.return_(this.b.functionCall(0, (Block)this.b.localVariable("e"), "getMessage", new Block[0]))}))})));
    }

    @Test
    public void exceptionStackUnwinding() {
        class Op {
            Op() {
            }

            public void throw_(int depth, String message) {
                LValueBlock $depth = BasicTest.this.b.localVariable("depth");
                CpsFunction f = new CpsFunction(List.of("depth", "message"), BasicTest.this.b.block(new Block[]{BasicTest.this.b.if_(BasicTest.this.b.lessThan(0, BasicTest.this.b.zero(), (Block)$depth), BasicTest.this.b.functionCall(0, BasicTest.this.b.this_(), "throw_", new Block[]{BasicTest.this.b.minus(0, (Block)$depth, BasicTest.this.b.one()), BasicTest.this.b.localVariable("message")}), BasicTest.this.b.throw_(0, BasicTest.this.b.new_(0, IllegalArgumentException.class, new Block[]{BasicTest.this.b.localVariable("message")})))}));
                throw new CpsCallableInvocation((CpsCallable)f, (Object)this, new Object[]{depth, message});
            }
        }
        Assert.assertEquals((Object)"hello1", (Object)this.run(this.b.setLocalVariable(0, "x", this.b.zero()), this.b.tryCatch(this.b.block(new Block[]{this.b.setLocalVariable(0, "x", this.b.one()), this.b.functionCall(0, this.b.constant((Object)new Op()), "throw_", new Block[]{this.b.constant((Object)3), this.b.constant((Object)"hello")}), this.b.setLocalVariable(0, "x", this.b.two())}), null, new CatchExpression[]{new CatchExpression(Exception.class, "e", this.b.return_(this.b.plus(0, (Block)this.b.property(0, (Block)this.b.localVariable("e"), "message"), (Block)this.b.localVariable("x"))))})));
    }

    @Test
    public void propertyGetAccess() {
        Assert.assertEquals((Object)"foo", (Object)this.run(this.b.setLocalVariable(0, "x", this.b.new_(0, Exception.class, new Block[]{this.b.constant((Object)"foo")})), this.b.new_(0, String.class, new Block[]{this.b.property(0, (Block)this.b.property(0, this.$x, "message"), "bytes")})));
    }

    @Test
    public void propertySetAccess() {
        PropertyTest p = new PropertyTest();
        this.run(this.b.setLocalVariable(0, "x", this.b.constant((Object)p)), this.b.setProperty(0, this.$x, "x", this.b.one()), this.b.setProperty(0, this.$x, "y", this.b.two()));
        Assert.assertEquals((long)p.x, (long)1L);
        Assert.assertEquals((long)p.y, (long)2L);
    }

    @Test
    public void yieldNull() {
        Assert.assertNull((Object)this.run(this.b.return_(this.b.null_())));
    }

    @Test
    public void blockScopedVariable() {
        Assert.assertEquals((Object)0, (Object)this.run(this.b.if_(this.b.true_(), this.b.sequence(this.b.declareVariable(Integer.TYPE, "x"), this.b.setLocalVariable(0, "x", this.b.one()))), this.b.declareVariable(Integer.TYPE, "x"), this.b.return_(this.$x)));
    }

    public static class InstantiationTest {
        int v;

        public InstantiationTest(int x, int y) {
            this.v = x + y;
        }

        public InstantiationTest(int x) {
            this.v = x;
        }
    }

    public static class PropertyTest {
        private int x = 0;
        public int y = 0;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }
}

