/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.sandbox;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.CpsTransformer;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.SandboxCpsTransformer;
import com.cloudbees.groovy.cps.impl.FunctionCallEnv;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.groovy.cps.sandbox.SandboxInvoker;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.ProxyGeneratorAdapter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kohsuke.groovy.sandbox.ClassRecorder;
import org.kohsuke.groovy.sandbox.impl.GroovyCallSiteSelector;

public class SandboxInvokerTest
extends AbstractGroovyCpsTest {
    ClassRecorder cr = new ClassRecorder();

    @Override
    protected CpsTransformer createCpsTransformer() {
        return new SandboxCpsTransformer();
    }

    @Before
    public void zeroIota() {
        CpsTransformer.iota.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalCpsSandbox(String expression, Object expectedResult, AbstractGroovyCpsTest.ExceptionHandler handler) {
        FunctionCallEnv env = (FunctionCallEnv)Envs.empty();
        env.setInvoker((Invoker)new SandboxInvoker());
        this.cr.reset();
        this.cr.register();
        try {
            Object actual = this.parseCps((String)expression).invoke((Env)env, null, (Continuation)Continuation.HALT).run().yield.replay();
            String actualType = GroovyCallSiteSelector.getName((Object)actual);
            String expectedType = GroovyCallSiteSelector.getName((Object)expectedResult);
            this.ec.checkThat("CPS and sandbox-transformed result (" + actualType + ") does not match expected result (" + expectedType + ")", actual, CoreMatchers.equalTo((Object)expectedResult));
        }
        catch (Throwable t) {
            this.ec.checkSucceeds(() -> {
                try {
                    handler.handleException(t);
                }
                catch (Throwable t2) {
                    t2.addSuppressed(t);
                    throw t2;
                }
                return null;
            });
        }
        finally {
            this.cr.unregister();
        }
    }

    @Override
    public void assertEvaluate(Object expectedReturnValue, String script) {
        this.evalCpsSandbox(script, expectedReturnValue, e -> {
            throw new RuntimeException("Failed to evaluate CPS and sandboxed-transformed script: " + script, e);
        });
    }

    public void assertIntercept(String script, Object expectedResult, String ... expectedCalls) throws Throwable {
        this.assertEvaluate(expectedResult, script);
        String[] updatedExpectedCalls = expectedCalls;
        if (expectedCalls.length == 0 || expectedCalls.length > 0 && !expectedCalls[0].equals("new SerializableScript()")) {
            updatedExpectedCalls = new String[expectedCalls.length + 1];
            updatedExpectedCalls[0] = "new SerializableScript()";
            System.arraycopy(expectedCalls, 0, updatedExpectedCalls, 1, expectedCalls.length);
        }
        this.ec.checkThat((Object)this.cr.toString().split("\n"), CoreMatchers.equalTo((Object)updatedExpectedCalls));
    }

    @Test
    public void basic() throws Throwable {
        this.assertIntercept("import java.awt.Point;\n\ndef p = new Point(1,3);\nassert p.equals(p)\nassert 4 == p.x+p.y;\np.x = 5;\nassert 5 == p.@x;\np.@x = 6;\n\ndef a = new int[3];\na[1] = a[0]+7;\nassert a[1]==7;\n", null, "Script1.super(Script1).setBinding(Binding)", "new Point(Integer,Integer)", "Point.equals(Point)", "Point.x", "Point.y", "Double.plus(Double)", "ScriptBytecodeAdapter:compareEqual(Integer,Double)", "Point.x=Integer", "Point.@x", "ScriptBytecodeAdapter:compareEqual(Integer,Integer)", "Point.@x=Integer", "int[][Integer]", "Integer.plus(Integer)", "int[][Integer]=Integer", "int[][Integer]", "ScriptBytecodeAdapter:compareEqual(Integer,Integer)");
    }

    @Test
    public void mixtureOfNonTransformation() throws Throwable {
        this.assertIntercept("@NonCPS\ndef length(x) {\n    return x.length();\n}\nreturn length('foo')\n", 3, "Script1.super(Script1).setBinding(Binding)", "Script1.length(String)", "String.length()");
    }

    @Test
    public void matcherTypeAssignment() throws Throwable {
        this.assertIntercept("@NonCPS\ndef nonCPSMatcherMethod(String x) {\n   java.util.regex.Matcher m = x =~ /bla/\n   return m.matches()\n}\ndef cpsMatcherMethod(String x) {\n    java.util.regex.Matcher m = x =~ /bla/\n    return m.matches()\n}\nreturn \"${nonCPSMatcherMethod('foo')}${cpsMatcherMethod('foo')}\".toString()\n", "falsefalse", "Script1.super(Script1).setBinding(Binding)", "Script1.nonCPSMatcherMethod(String)", "ScriptBytecodeAdapter:findRegex(String,String)", "Matcher.matches()", "Script1.cpsMatcherMethod(String)", "ScriptBytecodeAdapter:findRegex(String,String)", "Matcher.matches()", "new GStringImpl(Object[],String[])", "GStringImpl.toString()");
    }

    @Test
    public void mixingTrustedAndUntrusted() throws Throwable {
        TrustedCpsCompiler trusted = new TrustedCpsCompiler();
        trusted.setUp();
        SandboxInvokerTest untrusted = this;
        untrusted.getBinding().setVariable("trusted", (Object)trusted.getCsh().parse("def foo(x) { return [new java.awt.Point(1,x),untrusted.bar()] }"));
        this.cr.register();
        try {
            trusted.getBinding().setVariable("untrusted", (Object)untrusted.getCsh().parse("def bar() { return new File('foo') }"));
        }
        finally {
            this.cr.unregister();
        }
        this.assertIntercept("trusted.foo(4)", List.of(new Point(1, 4), new File("foo")), "Script2.super(Script2).setBinding(Binding)", "Script2.trusted", "Script1.foo(Integer)", "new File(String)");
    }

    @Test
    public void superClass() throws Throwable {
        this.assertIntercept("class Foo extends SandboxInvokerTest.Base {\n    public String toString() {\n        return 'x'+super.toString();\n    }\n}\nclass Bar extends Foo {}\nnew Bar().toString();\n", "xbase", "Script1.super(Script1).setBinding(Binding)", "new Bar()", "new Foo()", "new SandboxInvokerTest$Base()", "Bar.toString()", "Bar.super(Foo).toString()", "String.plus(String)");
    }

    @Test
    public void transformedSuperClass() throws Throwable {
        this.assertIntercept("class Foo extends SandboxInvokerTest.Base {\n    public String other() {\n        return 'base'\n    }\n}\nclass Bar extends Foo {\n    public String other() {\n        return 'y'+super.other()\n    }\n}\nnew Bar().other();\n", "ybase", "Script1.super(Script1).setBinding(Binding)", "new Bar()", "new Foo()", "new SandboxInvokerTest$Base()", "Bar.other()", "Bar.super(Bar).other()", "String.plus(String)");
    }

    @Test
    public void constructors() throws Throwable {
        this.assertIntercept("import java.awt.Point;\nclass C {\n    Point p\n    C() {\n        p = new Point(1, 3)\n    }\n}\nassert new C().p.y == 3\n", null, "Script1.super(Script1).setBinding(Binding)", "new C()", "new Point(Integer,Integer)", "C.p", "Point.y", "ScriptBytecodeAdapter:compareEqual(Double,Integer)");
    }

    @Test
    public void fields() throws Throwable {
        this.assertIntercept("import java.awt.Point;\nclass C {\n    Point p = new Point(1, 3)\n}\nassert new C().p.y == 3\n", null, "Script1.super(Script1).setBinding(Binding)", "new C()", "new Point(Integer,Integer)", "C.p", "Point.y", "ScriptBytecodeAdapter:compareEqual(Double,Integer)");
    }

    @Test
    public void initializers() throws Throwable {
        this.assertIntercept("import java.awt.Point;\nclass C {\n    Point p\n    {\n        p = new Point(1, 3)\n    }\n}\nassert new C().p.y == 3\n", null, "Script1.super(Script1).setBinding(Binding)", "new C()", "new Point(Integer,Integer)", "C.p", "Point.y", "ScriptBytecodeAdapter:compareEqual(Double,Integer)");
    }

    @Test
    public void typeCoercion() throws Throwable {
        Field pxyCounterField = ProxyGeneratorAdapter.class.getDeclaredField("pxyCounter");
        pxyCounterField.setAccessible(true);
        AtomicLong pxyCounterValue = (AtomicLong)pxyCounterField.get(null);
        pxyCounterValue.set(0L);
        this.assertIntercept("interface Static {\n    Locale[] getAvailableLocales()\n}\ninterface Instance {\n    String getCountry()\n}\nassert (Locale as Static).getAvailableLocales() != null\nassert (Locale as Static).availableLocales != null\nassert Locale.getAvailableLocales() != null\nassert (Locale.getDefault() as Instance).getCountry() != null\nassert (Locale.getDefault() as Instance).country != null\nassert Locale.getDefault().getCountry() != null\n", null, "Script1.super(Script1).setBinding(Binding)", "Locale:getAvailableLocales()", "Class1_groovyProxy.getAvailableLocales()", "ScriptBytecodeAdapter:compareNotEqual(Locale[],null)", "Locale:getAvailableLocales()", "Class1_groovyProxy.availableLocales", "ScriptBytecodeAdapter:compareNotEqual(Locale[],null)", "Locale:getAvailableLocales()", "ScriptBytecodeAdapter:compareNotEqual(Locale[],null)", "Locale:getDefault()", "Locale.getCountry()", "Locale2_groovyProxy.getCountry()", "ScriptBytecodeAdapter:compareNotEqual(String,null)", "Locale:getDefault()", "Locale.getCountry()", "Locale2_groovyProxy.country", "ScriptBytecodeAdapter:compareNotEqual(String,null)", "Locale:getDefault()", "Locale.getCountry()", "ScriptBytecodeAdapter:compareNotEqual(String,null)");
    }

    @Test
    public void methodPointers() throws Throwable {
        this.assertIntercept("import java.util.concurrent.Callable\ndef b = new SandboxInvokerTest.Base()\n(b.&noArg)() \n(b.&multipleArgs)('Kohsuke', 'Kawaguchi') \n(b.&oneArg)('Something')\n['Something'].each(b.&oneArg)\nCallable c = b.&noArg\nc()\ndef runit(Callable c) {c()}\nrunit({-> b.noArg()})\nrunit(b.&noArg)\nrunit({-> b.noArg()} as Callable)\nrunit(b.&noArg as Callable)\n", "No argument", "Script1.super(Script1).setBinding(Binding)", "new SandboxInvokerTest$Base()", "SandboxedMethodClosure.call()", "SandboxInvokerTest$Base.noArg()", "SandboxedMethodClosure.call(String,String)", "SandboxInvokerTest$Base.multipleArgs(String,String)", "SandboxedMethodClosure.call(String)", "SandboxInvokerTest$Base.oneArg(String)", "ArrayList.each(SandboxedMethodClosure)", "SandboxInvokerTest$Base.oneArg(String)", "SandboxedMethodClosure.call()", "SandboxInvokerTest$Base.noArg()", "Script1.runit(CpsClosure)", "CpsClosure.call()", "SandboxInvokerTest$Base.noArg()", "Script1.runit(SandboxedMethodClosure)", "SandboxedMethodClosure.call()", "SandboxInvokerTest$Base.noArg()", "Script1.runit(CpsClosure)", "CpsClosure.call()", "SandboxInvokerTest$Base.noArg()", "Script1.runit(SandboxedMethodClosure)", "SandboxedMethodClosure.call()", "SandboxInvokerTest$Base.noArg()");
    }

    @Test
    public void methodPointersStatic() throws Throwable {
        this.assertIntercept("(SandboxInvokerTest.Base.&staticMultipleArgs)('Kohsuke', 'Kawaguchi')\n(SandboxInvokerTest.Base.&staticNoArg)()\n(SandboxInvokerTest.Base.&staticOneArg)('Something')\n", "Just one arg: Something", "Script1.super(Script1).setBinding(Binding)", "SandboxedMethodClosure.call(String,String)", "SandboxInvokerTest$Base:staticMultipleArgs(String,String)", "SandboxedMethodClosure.call()", "SandboxInvokerTest$Base:staticNoArg()", "SandboxedMethodClosure.call(String)", "SandboxInvokerTest$Base:staticOneArg(String)");
    }

    @Test
    public void sandboxedMultipleAssignment() throws Throwable {
        this.assertIntercept("def (a, b) = ['first', 'second']\ndef c, d\n(c, d) = ['third', 'fourth']\nreturn a + b + c + d\n", "firstsecondthirdfourth", "Script1.super(Script1).setBinding(Binding)", "ArrayList[Integer]", "ArrayList[Integer]", "ArrayList[Integer]", "ArrayList[Integer]", "String.plus(String)", "String.plus(String)", "String.plus(String)");
    }

    @Test
    public void typeCoercionMultipleAssignment() throws Throwable {
        Field pxyCounterField = ProxyGeneratorAdapter.class.getDeclaredField("pxyCounter");
        pxyCounterField.setAccessible(true);
        AtomicLong pxyCounterValue = (AtomicLong)pxyCounterField.get(null);
        pxyCounterValue.set(0L);
        this.assertIntercept("interface Static {\n    Locale[] getAvailableLocales()\n}\ninterface Instance {\n    String getCountry()\n}\ndef (a, b) = [Locale as Static, Locale.getDefault() as Instance]\nassert a.getAvailableLocales() != null\nassert b.country != null\n", null, "Script1.super(Script1).setBinding(Binding)", "Locale:getAvailableLocales()", "Locale:getDefault()", "Locale.getCountry()", "ArrayList[Integer]", "ArrayList[Integer]", "Class1_groovyProxy.getAvailableLocales()", "ScriptBytecodeAdapter:compareNotEqual(Locale[],null)", "Locale2_groovyProxy.country", "ScriptBytecodeAdapter:compareNotEqual(String,null)");
    }

    @Test
    public void sandboxedMultipleAssignmentRunsMethodOnce() throws Throwable {
        this.assertIntercept("alreadyRun = false\ndef getAandB() {\n  if (!alreadyRun) {\n    alreadyRun = true\n    return ['first', 'second']\n  } else {\n    return ['bad', 'worse']\n  }\n}\ndef (a, b) = getAandB()\ndef c, d\n(c, d) = ['third', 'fourth']\nreturn a + b + c + d\n", "firstsecondthirdfourth", "Script1.super(Script1).setBinding(Binding)", "Script1.alreadyRun=Boolean", "Script1.getAandB()", "Script1.alreadyRun", "Script1.alreadyRun=Boolean", "ArrayList[Integer]", "ArrayList[Integer]", "ArrayList[Integer]", "ArrayList[Integer]", "String.plus(String)", "String.plus(String)", "String.plus(String)");
    }

    @Test
    public void finalizerForbidden() throws Throwable {
        this.evalCpsSandbox("class Test { @Override public void finalize() { } }; null", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            MultipleCompilationErrorsException e = (MultipleCompilationErrorsException)t;
            MatcherAssert.assertThat((Object)e.getErrorCollector().getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)1));
            Exception innerE = e.getErrorCollector().getException(0);
            MatcherAssert.assertThat((Object)innerE, (Matcher)CoreMatchers.instanceOf(SecurityException.class));
            MatcherAssert.assertThat((Object)innerE.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object.finalize()"));
        });
    }

    @Test
    public void nonCpsfinalizerForbidden() throws Throwable {
        this.evalCpsSandbox("class Test { @Override @NonCPS public void finalize() { } }; null", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            MultipleCompilationErrorsException e = (MultipleCompilationErrorsException)t;
            MatcherAssert.assertThat((Object)e.getErrorCollector().getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)1));
            Exception innerE = e.getErrorCollector().getException(0);
            MatcherAssert.assertThat((Object)innerE, (Matcher)CoreMatchers.instanceOf(SecurityException.class));
            MatcherAssert.assertThat((Object)innerE.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object.finalize()"));
        });
    }

    @Test
    public void methodParametersWithInitialExpressions() throws Throwable {
        this.assertIntercept("def m(p = System.getProperties()){ true }; m()", true, "Script1.super(Script1).setBinding(Binding)", "Script1.m()", "System:getProperties()", "Script1.m(Properties)");
    }

    @Test
    public void constructorParametersWithInitialExpressions() throws Throwable {
        this.assertIntercept("class Test {\n  Test(p = System.getProperties()) { }}\nnew Test()\nnull", null, "Script1.super(Script1).setBinding(Binding)", "new Test()", "System:getProperties()", "new Test(Properties)");
    }

    @Ignore(value="Initial expressions for parameters in CPS-transformed closures are currently ignored")
    @Test
    public void closureParametersWithInitialExpressions() throws Throwable {
        this.assertIntercept("{ p = System.getProperties() -> p != null }()", true, "Script1.super(Script1).setBinding(Binding)", "CpsClosure.call()", "System:getProperties()", "ScriptBytecodeAdapter:compareNotEqual(null,null)");
    }

    @Test
    public void sandboxInterceptsImplicitCastsVariableAssignment() throws Throwable {
        this.assertIntercept("File file\nfile = ['secret.key']\n file", new File("secret.key"), "Script1.super(Script1).setBinding(Binding)", "new File(String)");
    }

    @Test
    public void sandboxInterceptsImplicitCastsArrayAssignment() throws Throwable {
        this.evalCpsSandbox("File[] files = [null]\nfiles[0] = ['secret.key']\n files[0]", AbstractGroovyCpsTest.ShouldFail.class, t -> Assert.assertEquals((Object)"java.lang.ArrayStoreException: java.util.ArrayList", (Object)t.toString()));
    }

    @Test
    public void sandboxInterceptsImplicitCastsInitialParameterExpressions() throws Throwable {
        this.assertIntercept("def method(File file = ['secret.key']) { file }; method()", new File("secret.key"), "Script1.super(Script1).setBinding(Binding)", "Script1.method()", "new File(String)", "Script1.method(File)");
        this.assertIntercept("({ File file = ['secret.key'] -> file })()", null, "Script2.super(Script2).setBinding(Binding)", "CpsClosure.call()");
        this.assertIntercept("class Test {\n  def x\n  Test(File file = ['secret.key']) {\n   x = file\n  }\n}\nnew Test().x", new File("secret.key"), "Script3.super(Script3).setBinding(Binding)", "new Test()", "new File(String)", "new Test(File)", "Test.x");
    }

    @Test
    public void sandboxInterceptsImplicitCastsFields() throws Throwable {
        this.assertIntercept("class Test {\n  File file = ['secret.key']\n}\nnew Test().file", new File("secret.key"), "Script1.super(Script1).setBinding(Binding)", "new Test()", "new File(String)", "Test.file");
        this.assertIntercept("@groovy.transform.Field File file = ['secret.key']\nfile", new File("secret.key"), "new File(String)", "Script2.super(Script2).setBinding(Binding)", "Script2.file");
    }

    @Test
    public void sandboxInterceptsArrayCastsRecursively() throws Throwable {
        this.assertIntercept("([['secret.key']] as File[])[0]", new File("secret.key"), "Script1.super(Script1).setBinding(Binding)", "new File(String)", "File[][Integer]");
    }

    @Test
    public void sandboxInterceptsBooleanCasts() throws Throwable {
        this.assertIntercept("if ([:]) { true } else { false }", false, "Script1.super(Script1).setBinding(Binding)", "LinkedHashMap.asBoolean()");
        this.assertIntercept("if (['a' : 1]) { true } else { false }", true, "Script2.super(Script2).setBinding(Binding)", "LinkedHashMap.asBoolean()");
    }

    @Test
    public void dynamicMethodPointer() throws Throwable {
        this.assertIntercept("def method3() {\n    true\n}\ndef mp = this.&/method${1 + 2}/\nmp()", true, "Script1.super(Script1).setBinding(Binding)", "Integer.plus(Integer)", "new GStringImpl(Object[],String[])", "SandboxedMethodClosure.call()", "Script1.method3()");
    }

    @Test
    public void castsInTrustedCodeCalledByUntrustedCodeShouldNotBeIntercepted() throws Throwable {
        TrustedCpsCompiler trusted = new TrustedCpsCompiler();
        trusted.setUp();
        this.getBinding().setVariable("trusted", (Object)trusted.getCsh().parse("def foo() { File f = ['secret.key'] }"));
        this.assertIntercept("trusted.foo()", new File("secret.key"), "Script1.super(Script1).setBinding(Binding)", "Script1.trusted", "Script1.foo()");
    }

    @Ignore(value="This variant of JENKINS-70108 seems less likely to cause problems in practice and is more complex to fix")
    @Test
    public void booleanCastsInTrustedCodeCalledByUntrustedCodeShouldNotBeIntercepted() throws Throwable {
        TrustedCpsCompiler trusted = new TrustedCpsCompiler();
        trusted.setUp();
        this.getBinding().setVariable("trusted", (Object)trusted.getCsh().parse("class Test { @NonCPS def asBoolean() { false } }\ndef foo() { if (new Test()) { 123 } else { 456 } }"));
        this.assertIntercept("trusted.foo()", 456, "Script1.super(Script1).setBinding(Binding)", "Script1.trusted", "Script1.foo()");
    }

    static class TrustedCpsCompiler
    extends AbstractGroovyCpsTest {
        TrustedCpsCompiler() {
        }
    }

    public static class Base {
        public String toString() {
            return "base";
        }

        String multipleArgs(String first, String second) {
            return "Hello, " + first + " " + second;
        }

        String noArg() {
            return "No argument";
        }

        String oneArg(String first) {
            return "Just one arg: " + first;
        }

        public static String staticMultipleArgs(String first, String second) {
            return "Hello, " + first + " " + second;
        }

        public static String staticNoArg() {
            return "No argument";
        }

        public static String staticOneArg(String first) {
            return "Just one arg: " + first;
        }
    }
}

