/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools.internal;

import com.checkmarx.jenkins.tools.Platform;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;

public class DownloadService {
    private static final String CHECKMARX_FILE_NAME = "ast-cli";
    private static final String CHECKMARX_CLI_REPO = "https://api.github.com/repos/CheckmarxDev/ast-cli";
    private static final String CHECKMARX_CLI_RELEASES_LATEST = "https://api.github.com/repos/CheckmarxDev/ast-cli/releases/latest";
    private static final String CHECKMARX_RELEASES_TAGS = "https://api.github.com/repos/CheckmarxDev/ast-cli/releases/tags/%s";
    private static final String CHECKMARX_DOWNLOAD = "https://github.com/CheckmarxDev/ast-cli/releases/download/%s/%s";

    private DownloadService() {
    }

    public static URL getDownloadUrlForCli(@NonNull String version, @NonNull Platform platform) throws IOException {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        String jsonString = DownloadService.loadJSON("latest".equals(version) ? CHECKMARX_CLI_RELEASES_LATEST : String.format(CHECKMARX_RELEASES_TAGS, version));
        JSONObject release = JSONObject.fromObject((Object)jsonString);
        String tagName = (String)release.get("tag_name");
        String url = String.format(CHECKMARX_DOWNLOAD, tagName, DownloadService.buildFileName(tagName, platform));
        return new URL(url);
    }

    public static String buildFileName(String tagName, Platform platform) {
        return String.format("%s_%s_%s", CHECKMARX_FILE_NAME, tagName, platform.packageExtension);
    }

    private static String loadJSON(String source) throws IOException {
        URL sourceUrl = new URL(source);
        return IOUtils.toString((URL)sourceUrl, (Charset)StandardCharsets.UTF_8);
    }
}

