/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools;

import com.checkmarx.jenkins.CxLoggerAdapter;
import com.checkmarx.jenkins.tools.CheckmarxInstallation;
import com.checkmarx.jenkins.tools.Platform;
import com.checkmarx.jenkins.tools.ToolDetectionException;
import com.checkmarx.jenkins.tools.internal.DownloadService;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CheckmarxInstaller
extends ToolInstaller {
    private static final String INSTALLED_FROM = ".installedFrom";
    private static final String TIMESTAMP_FILE = ".timestamp";
    private final String version;
    private final Long updatePolicyIntervalHours;
    private CxLoggerAdapter log;

    @DataBoundConstructor
    public CheckmarxInstaller(String label, String version, Long updatePolicyIntervalHours) {
        super(label);
        this.version = version;
        this.updatePolicyIntervalHours = updatePolicyIntervalHours;
    }

    public FilePath performInstallation(ToolInstallation toolInstallation, Node node, TaskListener taskListener) throws IOException, InterruptedException {
        this.log = new CxLoggerAdapter(taskListener.getLogger());
        FilePath expected = this.preferredLocation(toolInstallation, node);
        if (this.isUpToDate(expected, this.log)) {
            this.log.info("Checkmarx installation is UP-TO-DATE");
            return expected;
        }
        this.log.info("Installing Checkmarx AST CLI tool (version '" + Util.fixEmptyAndTrim((String)this.version) + "')");
        return this.installCheckmarxCliAsSingleBinary(expected, node, taskListener);
    }

    private boolean isUpToDate(FilePath expectedLocation, CxLoggerAdapter log) throws IOException, InterruptedException {
        long timestampFromFile;
        FilePath marker = expectedLocation.child(TIMESTAMP_FILE);
        if (!marker.exists()) {
            return false;
        }
        String content = StringUtils.chomp((String)marker.readToString());
        try {
            timestampFromFile = Long.parseLong(content);
        }
        catch (NumberFormatException ex) {
            log.error(".timestamp file is corrupt and cannot be read and will be reset to 0.");
            timestampFromFile = 0L;
        }
        long timestampNow = Instant.now().toEpochMilli();
        long timestampDifference = timestampNow - timestampFromFile;
        if (timestampDifference <= 0L) {
            return true;
        }
        long updateInterval = TimeUnit.HOURS.toMillis(this.updatePolicyIntervalHours);
        return timestampDifference < updateInterval;
    }

    private FilePath installCheckmarxCliAsSingleBinary(FilePath expected, Node node, TaskListener log) throws IOException, InterruptedException {
        VirtualChannel nodeChannel = node.getChannel();
        if (nodeChannel == null) {
            throw new IOException(String.format("Node '%s' is offline", node.getDisplayName()));
        }
        Platform platform = (Platform)((Object)nodeChannel.call((Callable)new GetPlatform(node.getDisplayName())));
        try {
            URL checkmarxDownloadUrl = DownloadService.getDownloadUrlForCli(this.version, platform);
            expected.mkdirs();
            nodeChannel.call((Callable)new Downloader(checkmarxDownloadUrl, expected.child(DownloadService.buildFileName(this.version, platform)), expected.child(platform.checkmarxWrapperFileName)));
            expected.child(INSTALLED_FROM).write(checkmarxDownloadUrl.toString(), StandardCharsets.UTF_8.name());
            expected.child(TIMESTAMP_FILE).write(String.valueOf(Instant.now().toEpochMilli()), StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            log.getLogger().println("Checkmarx Security tool could not installed: " + ex.getMessage());
            throw new ToolDetectionException("Could not install Checkmarx CLI from binary", ex);
        }
        return expected;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getUpdatePolicyIntervalHours() {
        return this.updatePolicyIntervalHours;
    }

    private static class Downloader
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = 1L;
        private final URL downloadUrl;
        private final FilePath output;
        private final FilePath executableFile;

        Downloader(URL downloadUrl, FilePath output, FilePath executableFile) {
            this.downloadUrl = downloadUrl;
            this.output = output;
            this.executableFile = executableFile;
        }

        public Void call() throws IOException {
            boolean result;
            File downloadedFile = new File(this.output.getRemote());
            FileUtils.copyURLToFile((URL)this.downloadUrl, (File)downloadedFile, (int)10000, (int)10000);
            try {
                Downloader.extract(downloadedFile.getAbsolutePath(), downloadedFile.getParent());
            }
            catch (ArchiveException | CompressorException e) {
                throw new IOException(String.format("Could not extract cli: %s", downloadedFile.getAbsolutePath()));
            }
            File cxExecutable = new File(this.executableFile.getRemote());
            if (!Functions.isWindows() && cxExecutable.isFile() && !(result = cxExecutable.setExecutable(true, false))) {
                throw new IOException(String.format("Could not set executable flag for the file: %s", downloadedFile.getAbsolutePath()));
            }
            return null;
        }

        public static void extract(String srcFile, String dest) throws ArchiveException, IOException, CompressorException {
            ArchiveEntry nextEntry;
            boolean outputFileExisted;
            FileInputStream fileInputStream = new FileInputStream(srcFile);
            ArchiveInputStream archiveInputStream = Downloader.generateArchiveInputStream(fileInputStream, srcFile);
            File outputFile = new File(dest);
            boolean bl = outputFileExisted = outputFile.exists() || outputFile.mkdirs();
            if (!outputFileExisted) {
                throw new IOException("Unable to create path");
            }
            while ((nextEntry = archiveInputStream.getNextEntry()) != null) {
                File tempFile = new File(dest, nextEntry.getName());
                if (nextEntry.isDirectory()) {
                    boolean folderExisted = tempFile.exists() || tempFile.mkdirs();
                    if (folderExisted) continue;
                    throw new IOException("Unable to create path");
                }
                FileOutputStream fos = FileUtils.openOutputStream((File)tempFile);
                IOUtils.copy((InputStream)archiveInputStream, (OutputStream)fos);
                fos.close();
            }
            archiveInputStream.close();
            fileInputStream.close();
        }

        private static ArchiveInputStream generateArchiveInputStream(FileInputStream fis, String srcFile) throws ArchiveException, CompressorException {
            String extension = FilenameUtils.getExtension((String)srcFile);
            ArchiveStreamFactory asf = new ArchiveStreamFactory();
            if (extension.toLowerCase().endsWith("tgz") || extension.toLowerCase().endsWith("gz")) {
                CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)new BufferedInputStream(fis));
                return asf.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)cis));
            }
            return asf.createArchiveInputStream((InputStream)new BufferedInputStream(fis));
        }
    }

    private static class GetPlatform
    extends MasterToSlaveCallable<Platform, IOException> {
        private static final long serialVersionUID = 1L;
        private final String nodeDisplayName;

        GetPlatform(String nodeDisplayName) {
            this.nodeDisplayName = nodeDisplayName;
        }

        public Platform call() throws IOException {
            try {
                return Platform.current();
            }
            catch (ToolDetectionException ex) {
                throw new IOException(String.format("Could not determine platform on node %s", this.nodeDisplayName));
            }
        }
    }

    @Extension
    public static final class CheckmarxInstallerDescriptor
    extends ToolInstallerDescriptor<CheckmarxInstaller> {
        public String getDisplayName() {
            return "Install from checkmarx.com";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == CheckmarxInstallation.class;
        }
    }
}

