/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins;

import com.checkmarx.ast.results.ReportFormat;
import com.checkmarx.ast.wrapper.CxConfig;
import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.ast.wrapper.CxWrapper;
import com.checkmarx.jenkins.CheckmarxScanBuilder;
import com.checkmarx.jenkins.CxLoggerAdapter;
import com.checkmarx.jenkins.model.ScanConfig;
import com.checkmarx.jenkins.tools.CheckmarxInstallation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.slf4j.Logger;

public class PluginUtils {
    public static final String CHECKMARX_AST_RESULTS_HTML = "checkmarx-ast-results.html";
    public static final String CHECKMARX_AST_RESULTS_JSON = "checkmarx-ast-results.json";
    public static final String REGEX_SCAN_ID_FROM_LOGS = "(ID)\":\"((\\\\\"|[^\"])*)";
    private static final String JENKINS = "Jenkins";

    public static CheckmarxInstallation findCheckmarxInstallation(String checkmarxInstallation) {
        CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor descriptor = (CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor)Jenkins.get().getDescriptorByType(CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor.class);
        return Stream.of(descriptor.getInstallations()).filter(installation -> installation.getName().equals(checkmarxInstallation)).findFirst().orElse(null);
    }

    public static List<String> submitScanDetailsToWrapper(ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException, InterruptedException, URISyntaxException, CxConfig.InvalidCLIConfigException, CxException {
        log.info("Submitting the scan details to the CLI wrapper.");
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        cxConfig.setAdditionalParameters(scanConfig.getAdditionalOptions());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("--agent", JENKINS);
        params.put("-s", scanConfig.getSourceDirectory());
        params.put("--project-name", scanConfig.getProjectName());
        params.put("--branch", scanConfig.getBranchName());
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildScanCreateArguments(params, scanConfig.getAdditionalOptions());
    }

    public static List<String> scanCancel(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException, InterruptedException, CxConfig.InvalidCLIConfigException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildScanCancelArguments(scanId);
    }

    public static List<String> generateHTMLReport(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException, InterruptedException, CxConfig.InvalidCLIConfigException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildResultsArguments(scanId, ReportFormat.summaryHTML);
    }

    public static List<String> generateJsonReport(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException, InterruptedException, CxException, URISyntaxException, CxConfig.InvalidCLIConfigException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildResultsArguments(scanId, ReportFormat.summaryJSON);
    }

    public static String authValidate(ScanConfig scanConfig, String checkmarxCliExecutable) throws IOException, InterruptedException, CxConfig.InvalidCLIConfigException, URISyntaxException, CxException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig);
        return cxWrapper.authValidate();
    }

    private static CxConfig initiateWrapperObject(ScanConfig scanConfig, String checkmarxCliExecutable) throws IOException, InterruptedException {
        return CxConfig.builder().baseUri(scanConfig.getServerUrl()).baseAuthUri(scanConfig.getBaseAuthUrl()).clientId(scanConfig.getCheckmarxToken().getClientId()).clientSecret(scanConfig.getCheckmarxToken().getToken().getPlainText()).tenant(scanConfig.getTenantName()).additionalParameters(null).pathToExecutable(checkmarxCliExecutable).build();
    }

    public static String getScanIdFromLogFile(String filename, CxLoggerAdapter log) {
        try {
            String regex = REGEX_SCAN_ID_FROM_LOGS;
            Pattern pattern = Pattern.compile(REGEX_SCAN_ID_FROM_LOGS);
            File logFile = new File(filename);
            Scanner logFileReader = new Scanner(logFile, StandardCharsets.UTF_8.name());
            while (logFileReader.hasNextLine()) {
                String logs = logFileReader.nextLine();
                Matcher matcher = pattern.matcher(logs);
                if (!matcher.find()) continue;
                return matcher.group(2);
            }
            logFileReader.close();
        }
        catch (FileNotFoundException err) {
            log.error("An error occurred while finding scanId in logs", err);
        }
        return "";
    }
}

