/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins;

import com.checkmarx.ast.results.ResultsSummary;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Run;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import jenkins.model.RunAction2;

public class CheckmarxScanResultsAction
implements RunAction2 {
    private transient Run<?, ?> run;

    public Run getRun() {
        return this.run;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return "/plugin/checkmarx-ast-scanner/images/CxIcon24x24.png";
    }

    public String getDisplayName() {
        return "Checkmarx Scan Results";
    }

    public String getUrlName() {
        return "scanResults";
    }

    public ResultsSummary getResultsSummary() {
        for (Object artifact : this.run.getArtifacts()) {
            if (!(artifact instanceof Run.Artifact) || !((Run.Artifact)artifact).getFileName().contains("checkmarx-ast-results.json")) continue;
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(((Run.Artifact)artifact).getFile().getCanonicalPath(), new String[0]));
                String json = new String(encoded, Charset.defaultCharset());
                ObjectMapper objectMapper = new ObjectMapper();
                return (ResultsSummary)objectMapper.readValue(json, ResultsSummary.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

