/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.bmc.ims.ResponseObject;
import com.bmc.ims.spoolObj;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class JCLService {
    private String encodedCredentials = null;
    private String authHeader = null;
    private String hostUrl = null;
    private final boolean debug;

    public JCLService(boolean debug) {
        this.debug = debug;
    }

    public void login(String host, String port, String user, String pw, TaskListener listener) throws AbortException {
        String toEncode = user + ":" + pw;
        this.encodedCredentials = Base64.getEncoder().encodeToString(toEncode.getBytes(Charset.forName("UTF-8")));
        boolean displayError = false;
        this.hostUrl = "https://" + host + ":" + port;
        String validateUrl = this.hostUrl + "/zosmf/info";
        try {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(validateUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.addRequestProperty("Authorization", "Basic " + this.encodedCredentials);
            conn.addRequestProperty("x-csrf-zosmf-header", "");
            int responseCode = conn.getResponseCode();
            String replyText = conn.getResponseMessage();
            if (this.debug) {
                listener.getLogger().println("HTTPS connection response code: " + responseCode + " and response message: " + replyText);
            }
            if (responseCode >= 200 && responseCode <= 299) {
                listener.getLogger().println("Successfully Connected to host " + this.hostUrl);
                this.authHeader = "Basic " + this.encodedCredentials;
            } else {
                displayError = true;
            }
            if (displayError) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String message = "Server returned " + responseCode + "\n" + response.toString();
                if (this.debug) {
                    listener.getLogger().println(message);
                }
                throw new AbortException();
            }
        }
        catch (IOException ex) {
            listener.getLogger().println("Connection to " + this.hostUrl + " failed");
            ex.printStackTrace();
            throw new AbortException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObject doGenericRequest(HttpURLConnection conn, String url, String method, String requestBody, Properties headers, TaskListener listener) {
        ResponseObject rc = new ResponseObject();
        try {
            String inputLine;
            StringBuffer response;
            BufferedReader in;
            InputStream istream;
            OutputStream os;
            if (headers != null) {
                Set<Object> keys = headers.keySet();
                for (Object key : keys) {
                    String tmp = headers.getProperty(key.toString());
                    conn.addRequestProperty(key.toString(), tmp);
                }
                conn.addRequestProperty("Authorization", this.authHeader);
                conn.addRequestProperty("x-csrf-zosmf-header", "");
                if (method.startsWith("P") && url.contains("workflows")) {
                    conn.addRequestProperty("Connection", "close");
                }
            }
            if (method.equals("POST") && requestBody != null && requestBody.toString().length() > 0) {
                conn.setDoOutput(true);
                os = conn.getOutputStream();
                os.write(requestBody.getBytes(Charset.forName("UTF-8")));
                os.flush();
                os.close();
            }
            if (method.equals("PUT") && requestBody != null && url.contains("/zosmf/restjobs/jobs")) {
                InputStream istream2;
                block71: {
                    os = null;
                    try {
                        conn.addRequestProperty("Content-Type", "text/plain");
                        conn.setDoOutput(true);
                        os = conn.getOutputStream();
                        os.write(requestBody.getBytes(Charset.forName("UTF-8")));
                        if (conn.getResponseCode() >= 200 && conn.getResponseCode() <= 299) {
                            if (this.debug) {
                                listener.getLogger().println("Job is successfully written to JES internal reader...");
                            }
                            break block71;
                        }
                        try {
                            istream2 = null;
                            istream2 = conn.getErrorStream();
                            if (istream2 != null) {
                                String inputLine2;
                                BufferedReader in2 = null;
                                StringBuffer response2 = new StringBuffer();
                                in2 = new BufferedReader(new InputStreamReader(istream2, "utf-8"));
                                while ((inputLine2 = in2.readLine()) != null) {
                                    response2.append(inputLine2);
                                    response2.append("\r\n");
                                }
                                in2.close();
                                if (this.debug) {
                                    listener.getLogger().println("Response of Error Stream Data:\n" + response2.toString());
                                }
                                rc.ret_code = 16;
                            }
                        }
                        catch (IOException ioex) {
                            listener.getLogger().println("JCLService: IO Error occured while reading error stream data");
                            ioex.printStackTrace();
                            listener.getLogger().println(ioex);
                            rc.ret_code = 8;
                        }
                    }
                    catch (IOException ioex) {
                        listener.getLogger().println("JCLService: IO Error occured while writing to JES internal reader");
                        ioex.printStackTrace();
                        listener.getLogger().println(ioex);
                        rc.ret_code = 8;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.flush();
                                os.close();
                            }
                            catch (IOException ioex) {
                                listener.getLogger().println("JCLService: IO error occured while closing outputStream");
                                ioex.printStackTrace();
                                listener.getLogger().println(ioex);
                                rc.ret_code = 8;
                            }
                        }
                    }
                }
                if (rc.ret_code != 8 && rc.ret_code != 16) {
                    try {
                        istream2 = conn.getInputStream();
                        if (istream2 != null) {
                            BufferedReader br = null;
                            StringBuffer sb = new StringBuffer();
                            String line = null;
                            br = new BufferedReader(new InputStreamReader(istream2, "utf-8"));
                            while ((line = br.readLine()) != null) {
                                sb.append(line);
                                sb.append("\r\n");
                            }
                            br.close();
                            if (this.debug) {
                                listener.getLogger().println("Response from Job Submission:\n" + sb.toString());
                            }
                            Gson gson = new Gson();
                            JsonObject resp = (JsonObject)gson.fromJson(sb.toString(), JsonObject.class);
                            rc.jobId = resp.get("jobid").getAsString();
                            rc.jobName = resp.get("jobname").getAsString();
                            rc.jobStatus = resp.get("status").getAsString();
                        }
                    }
                    catch (IOException ioex) {
                        listener.getLogger().println("JCLServices: IO Error occured while reading response data");
                        ioex.printStackTrace();
                        listener.getLogger().println(ioex);
                        rc.ret_code = 8;
                    }
                }
            }
            if (method.equals("GET") && requestBody.contains("Obtain Job Status") && !url.contains("/records") && !url.contains("/restfiles")) {
                try {
                    conn.addRequestProperty("Content-Type", "text/plain");
                    istream = null;
                    if (conn.getResponseCode() >= 200 && conn.getResponseCode() <= 299) {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getInputStream:");
                        }
                        if ((istream = conn.getInputStream()) != null) {
                            in = null;
                            response = new StringBuffer();
                            in = new BufferedReader(new InputStreamReader(istream, "utf-8"));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                                response.append("\n");
                            }
                            in.close();
                            JsonObject resp = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                            rc.jobName = resp.get("jobname").getAsString();
                            rc.jobId = resp.get("jobid").getAsString();
                            rc.jobStatus = resp.get("status").getAsString();
                            if (resp.get("status").getAsString().equals("OUTPUT") && this.debug) {
                                listener.getLogger().println("Response from Job Status:\n " + response.toString());
                            }
                        }
                    } else {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getErrorStream:");
                        }
                        if ((istream = conn.getErrorStream()) != null) {
                            in = null;
                            response = new StringBuffer();
                            in = new BufferedReader(new InputStreamReader(istream, "utf-8"));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                                response.append("\n");
                            }
                            in.close();
                            if (this.debug) {
                                listener.getLogger().println("Response data of error stream data:\n" + response.toString());
                            }
                        }
                    }
                }
                catch (IOException ioex) {
                    listener.getLogger().println("JCLServices: IO Error occured while reading the response data");
                    ioex.printStackTrace();
                    listener.getLogger().println(ioex);
                    rc.ret_code = 8;
                }
            }
            if (method.equals("GET") && requestBody.contains("List spool files")) {
                try {
                    conn.addRequestProperty("Content-Type", "text/plain");
                    istream = null;
                    if (conn.getResponseCode() >= 200 && conn.getResponseCode() <= 299) {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getInputStream:");
                        }
                        if ((istream = conn.getInputStream()) != null) {
                            in = null;
                            response = new StringBuffer();
                            in = new BufferedReader(new InputStreamReader(istream, "utf-8"));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                                response.append("\n");
                            }
                            in.close();
                            Gson gson = new Gson();
                            Type listType = new TypeToken<List<spoolObj>>(){}.getType();
                            List myObjectList = (List)gson.fromJson(response.toString(), listType);
                            for (spoolObj obj : myObjectList) {
                                rc.ddnamevalarr.add(obj.ddname);
                                rc.idvalarr.add(obj.id);
                            }
                        }
                    } else {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getErrorStream:");
                        }
                        if ((istream = conn.getErrorStream()) != null) {
                            in = null;
                            response = new StringBuffer();
                            in = new BufferedReader(new InputStreamReader(istream, "utf-8"));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                                response.append("\n");
                            }
                            in.close();
                            if (this.debug) {
                                listener.getLogger().println("Response data of error stream data:\n" + response.toString());
                            }
                        }
                    }
                }
                catch (IOException ioex) {
                    listener.getLogger().println("JCLServices: IO Error occured while reading the response data");
                    ioex.printStackTrace();
                    listener.getLogger().println(ioex);
                    rc.ret_code = 8;
                }
            }
            if (method.equals("GET") && requestBody.contains("Retrieve spool files content")) {
                try {
                    conn.addRequestProperty("Content-Type", "text/plain");
                    istream = null;
                    if (conn.getResponseCode() >= 200 && conn.getResponseCode() <= 299) {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getInputStream:");
                        }
                        rc.istream = conn.getInputStream();
                    } else {
                        if (this.debug) {
                            listener.getLogger().println("Read the response data from getErrorStream:");
                        }
                        if ((istream = conn.getErrorStream()) != null) {
                            in = null;
                            response = new StringBuffer();
                            in = new BufferedReader(new InputStreamReader(istream, "utf-8"));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                                response.append("\n");
                            }
                            in.close();
                            if (this.debug) {
                                listener.getLogger().println("Response data of error stream data:\n" + response.toString());
                            }
                        }
                    }
                }
                catch (IOException ioex) {
                    listener.getLogger().println("JCLServices: IO Error occured while reading the response data");
                    ioex.printStackTrace();
                    listener.getLogger().println(ioex);
                    rc.ret_code = 8;
                }
            }
            int responseCode = conn.getResponseCode();
            String statusLine = "HTTP/1.1 " + responseCode + " " + conn.getResponseMessage() + "\r\n";
            if (this.debug) {
                listener.getLogger().println("HTTPS response status: " + statusLine);
            }
            response = new StringBuffer();
            response.append(statusLine);
            this.addHeaders(response, conn.getHeaderFields());
            response.append("\r\n");
            rc.status = responseCode;
            rc.statAndHeaders = response;
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (ProtocolException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rc;
    }

    public ResponseObject doRequest(String url, String method, String requestBody, Properties headers, TaskListener listener) {
        ResponseObject rc = null;
        try {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod(method);
            rc = this.doGenericRequest(conn, url, method, requestBody, headers, listener);
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (ProtocolException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rc;
    }

    private void addHeaders(StringBuffer resp, Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            List<String> values = entry.getValue();
            Object value = "";
            ListIterator<String> li = values.listIterator();
            boolean first = true;
            while (li.hasNext()) {
                if (!first) {
                    value = (String)value + "; ";
                } else {
                    first = !first;
                }
                String tmp = li.next();
                value = ((String)value).concat(tmp);
            }
            resp.append(entry.getKey() + ": " + (String)value + "\n");
        }
    }
}

