/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CsvFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JsonObject> readCsvFile(String csvFilePath) {
        BufferedReader br = null;
        File file = new File(csvFilePath);
        ArrayList<JsonObject> jsonObjArr = new ArrayList<JsonObject>();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (i > 0) {
                    String[] values = line.split(",");
                    jsonObjArr.add(CsvFile.createJsonModel(values, file.getName()));
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonObjArr;
    }

    private static JsonObject createJsonModel(String[] values, String rptType) {
        JsonObject obj = new JsonObject();
        obj.addProperty("jobName", values[0]);
        if (rptType.contains("DB2")) {
            obj.addProperty("planName", values[1]);
            obj.addProperty("startTime", values[2]);
            obj.addProperty("commits#", values[3]);
            obj.addProperty("jobDuration", values[5]);
            obj.addProperty("freqPerMin", values[6]);
            obj.addProperty("freqPerSec", values[7]);
            obj.addProperty("exceptions", values[8]);
        } else if (rptType.contains("IMS") || rptType.contains("DLI")) {
            obj.addProperty("psbName", values[1]);
            obj.addProperty("startTime", values[2]);
            obj.addProperty("chkpt#", values[3]);
            obj.addProperty("chkptType", values[4]);
            obj.addProperty("jobDuration", values[5]);
            obj.addProperty("freqPerMin", values[6]);
            obj.addProperty("freqPerSec", values[7]);
            obj.addProperty("exceptions", values[8]);
        }
        return obj;
    }
}

