/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service.strategy;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.detect.DetectJenkinsEnvironmentVariable;
import com.blackduck.integration.jenkins.detect.exception.DetectJenkinsException;
import com.blackduck.integration.jenkins.detect.extensions.AirGapDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.DetectDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.InheritFromGlobalDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.global.DetectGlobalConfig;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectAirGapJarStrategy;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectExecutionStrategy;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectJarStrategy;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectScriptStrategy;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.service.JenkinsConfigService;
import com.blackduck.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.OperatingSystemType;
import org.apache.commons.lang3.StringUtils;

public class DetectStrategyService {
    private final JenkinsIntLogger logger;
    private final String remoteTempWorkspacePath;
    private final JenkinsProxyHelper jenkinsProxyHelper;
    private final JenkinsConfigService jenkinsConfigService;

    public DetectStrategyService(JenkinsIntLogger logger, JenkinsProxyHelper jenkinsProxyHelper, String remoteTempWorkspacePath, JenkinsConfigService jenkinsConfigService) {
        this.logger = logger;
        this.jenkinsProxyHelper = jenkinsProxyHelper;
        this.remoteTempWorkspacePath = remoteTempWorkspacePath;
        this.jenkinsConfigService = jenkinsConfigService;
    }

    public DetectExecutionStrategy getExecutionStrategy(IntEnvironmentVariables intEnvironmentVariables, OperatingSystemType operatingSystemType, String remoteJdkHome, DetectDownloadStrategy detectDownloadStrategy) throws IntegrationException {
        String loggingMessage = "Running Detect using configured strategy: ";
        if (detectDownloadStrategy == null || detectDownloadStrategy instanceof InheritFromGlobalDownloadStrategy) {
            DetectGlobalConfig detectGlobalConfig = (DetectGlobalConfig)this.jenkinsConfigService.getGlobalConfiguration(DetectGlobalConfig.class).orElseThrow(() -> new DetectJenkinsException("Could not find Detect configuration. Check Jenkins System Configuration to ensure Detect is configured correctly."));
            detectDownloadStrategy = detectGlobalConfig.getDownloadStrategy();
            if (detectDownloadStrategy == null) {
                detectDownloadStrategy = detectGlobalConfig.getDefaultDownloadStrategy();
                loggingMessage = "System configured strategy not found, running Detect using default configured system strategy: ";
            } else {
                loggingMessage = "Running Detect using configured system strategy: ";
            }
        }
        this.logger.info(loggingMessage + detectDownloadStrategy.getDisplayName());
        String detectJarPath = intEnvironmentVariables.getValue(DetectJenkinsEnvironmentVariable.USER_PROVIDED_JAR_PATH.stringValue());
        DetectExecutionStrategy detectExecutionStrategy = detectDownloadStrategy instanceof AirGapDownloadStrategy ? new DetectAirGapJarStrategy(this.logger, intEnvironmentVariables, remoteJdkHome, this.jenkinsConfigService, (AirGapDownloadStrategy)detectDownloadStrategy) : (StringUtils.isNotBlank((CharSequence)detectJarPath) ? new DetectJarStrategy(this.logger, intEnvironmentVariables, remoteJdkHome, detectJarPath) : new DetectScriptStrategy(this.logger, this.jenkinsProxyHelper, operatingSystemType, this.remoteTempWorkspacePath));
        return detectExecutionStrategy;
    }
}

