/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service.strategy;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectExecutionStrategy;
import com.blackduck.integration.jenkins.detect.service.strategy.RemoteJavaService;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.util.IntEnvironmentVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import jenkins.security.MasterToSlaveCallable;

public class DetectJarStrategy
extends DetectExecutionStrategy {
    private final JenkinsIntLogger logger;
    private final String detectJarPath;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final String remoteJdkHome;

    public DetectJarStrategy(JenkinsIntLogger logger, IntEnvironmentVariables intEnvironmentVariables, String remoteJdkHome, String detectJarPath) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.remoteJdkHome = remoteJdkHome;
        this.detectJarPath = detectJarPath;
    }

    @Override
    public Function<String, String> getArgumentEscaper() {
        return Function.identity();
    }

    @Override
    public MasterToSlaveCallable<ArrayList<String>, IntegrationException> getSetupCallable() {
        return new SetupCallableImpl(this.logger, this.intEnvironmentVariables.getVariables(), this.detectJarPath, this.remoteJdkHome);
    }

    public static class SetupCallableImpl
    extends MasterToSlaveCallable<ArrayList<String>, IntegrationException> {
        private static final long serialVersionUID = -8326836838838706367L;
        private final JenkinsIntLogger logger;
        private final Map<String, String> environmentVariables;
        private final String detectJarPath;
        private final String remoteJdkHome;

        public SetupCallableImpl(JenkinsIntLogger logger, Map<String, String> environmentVariables, String detectJarPath, String remoteJdkHome) {
            this.logger = logger;
            this.environmentVariables = environmentVariables;
            this.detectJarPath = detectJarPath;
            this.remoteJdkHome = remoteJdkHome;
        }

        public ArrayList<String> call() {
            RemoteJavaService remoteJavaService = new RemoteJavaService(this.logger, this.remoteJdkHome, this.environmentVariables);
            String javaExecutablePath = remoteJavaService.getJavaExecutablePath();
            this.logger.info("Detect jar configured: " + this.detectJarPath);
            return new ArrayList<String>(Arrays.asList(javaExecutablePath, "-jar", this.detectJarPath));
        }
    }
}

