/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service.strategy;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.detect.exception.DetectJenkinsException;
import com.blackduck.integration.jenkins.detect.extensions.AirGapDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.tool.DetectAirGapInstallation;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectExecutionStrategy;
import com.blackduck.integration.jenkins.detect.service.strategy.RemoteJavaService;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.service.JenkinsConfigService;
import com.blackduck.integration.util.IntEnvironmentVariables;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import jenkins.security.MasterToSlaveCallable;

public class DetectAirGapJarStrategy
extends DetectExecutionStrategy {
    public static final String DETECT_JAR_PREFIX = "detect-";
    public static final String FALLBACK_DETECT_JAR_PREFIX = "synopsys-detect-";
    public static final String DETECT_JAR_SUFFIX = ".jar";
    private final JenkinsIntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final String remoteJdkHome;
    private final JenkinsConfigService jenkinsConfigService;
    private final AirGapDownloadStrategy airGapDownloadStrategy;

    public DetectAirGapJarStrategy(JenkinsIntLogger logger, IntEnvironmentVariables intEnvironmentVariables, String remoteJdkHome, JenkinsConfigService jenkinsConfigService, AirGapDownloadStrategy airGapDownloadStrategy) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.remoteJdkHome = remoteJdkHome;
        this.jenkinsConfigService = jenkinsConfigService;
        this.airGapDownloadStrategy = airGapDownloadStrategy;
    }

    @Override
    public Function<String, String> getArgumentEscaper() {
        return Function.identity();
    }

    private String getOrDownloadAirGapJar() throws DetectJenkinsException {
        DetectAirGapInstallation airGapInstallation;
        try {
            String airGapInstallationName = this.airGapDownloadStrategy.getAirGapInstallationName();
            airGapInstallation = (DetectAirGapInstallation)((Object)this.jenkinsConfigService.getInstallationForNodeAndEnvironment(DetectAirGapInstallation.DescriptorImpl.class, airGapInstallationName).orElseThrow(() -> new DetectJenkinsException(String.format("Problem encountered getting Detect Air Gap tool with the name %s from global tool configuration. Check Jenkins plugin and tool configuration.", airGapInstallationName))));
        }
        catch (IOException e) {
            throw new DetectJenkinsException("Problem encountered while interacting with Jenkins environment. Check Jenkins and environment.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DetectJenkinsException("Getting Detect Air Gap tool was interrupted. Check Jenkins and environment.", e);
        }
        return airGapInstallation.getHome();
    }

    @Override
    public MasterToSlaveCallable<ArrayList<String>, IntegrationException> getSetupCallable() throws DetectJenkinsException {
        String airGapBaseDir = this.getOrDownloadAirGapJar();
        if (airGapBaseDir == null) {
            throw new DetectJenkinsException("Detect AirGap installation directory is null. Check Jenkins tool configuration for installation directory.");
        }
        return new SetupCallableImpl(this.logger, this.intEnvironmentVariables.getVariables(), this.remoteJdkHome, airGapBaseDir);
    }

    public static class SetupCallableImpl
    extends MasterToSlaveCallable<ArrayList<String>, IntegrationException> {
        private static final long serialVersionUID = -8326836838838706367L;
        private final JenkinsIntLogger logger;
        private final Map<String, String> environmentVariables;
        private final String remoteJdkHome;
        private final String airGapBaseDir;

        public SetupCallableImpl(JenkinsIntLogger logger, Map<String, String> environmentVariables, String remoteJdkHome, String airGapBaseDir) {
            this.logger = logger;
            this.environmentVariables = environmentVariables;
            this.remoteJdkHome = remoteJdkHome;
            this.airGapBaseDir = airGapBaseDir;
        }

        public ArrayList<String> call() throws DetectJenkinsException {
            String airGapJar = this.getAirGapJar(this.airGapBaseDir);
            RemoteJavaService remoteJavaService = new RemoteJavaService(this.logger, this.remoteJdkHome, this.environmentVariables);
            String javaExecutablePath = remoteJavaService.getJavaExecutablePath();
            this.logger.info("Detect AirGap jar configured: " + airGapJar);
            return new ArrayList<String>(Arrays.asList(javaExecutablePath, "-jar", airGapJar));
        }

        private String getAirGapJar(String airGapBaseDir) throws DetectJenkinsException {
            FileFilter fileFilter = file -> file.getName().startsWith(DetectAirGapJarStrategy.DETECT_JAR_PREFIX) && file.getName().endsWith(DetectAirGapJarStrategy.DETECT_JAR_SUFFIX);
            File[] foundAirGapJars = new File(airGapBaseDir).listFiles(fileFilter);
            FileFilter backUpFileFilter = file -> file.getName().startsWith(DetectAirGapJarStrategy.FALLBACK_DETECT_JAR_PREFIX) && file.getName().endsWith(DetectAirGapJarStrategy.DETECT_JAR_SUFFIX);
            File[] foundFallbackJars = new File(airGapBaseDir).listFiles(backUpFileFilter);
            if (!(foundAirGapJars != null && foundAirGapJars.length != 0 || foundFallbackJars != null && foundFallbackJars.length != 0)) {
                throw new DetectJenkinsException(String.format("Expected 1 jar from Detect Air Gap tool installation at <%s> and did not find any. Check your Jenkins plugin and tool configuration.", airGapBaseDir));
            }
            if (foundAirGapJars != null && foundAirGapJars.length > 1 || foundFallbackJars != null && foundFallbackJars.length > 1) {
                throw new DetectJenkinsException(String.format("Expected 1 jar from Detect Air Gap tool installation at <%s> and instead found multiple jars. Check your Jenkins plugin and tool configuration.", airGapBaseDir));
            }
            if (foundAirGapJars != null && foundAirGapJars.length == 1) {
                return foundAirGapJars[0].toString();
            }
            if (foundFallbackJars != null && foundFallbackJars.length == 1) {
                return foundFallbackJars[0].toString();
            }
            throw new DetectJenkinsException(String.format("Expected 1 jar from Detect Air Gap tool installation at <%s> and did not find any. Check your Jenkins plugin and tool configuration.", airGapBaseDir));
        }
    }
}

