/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service;

import com.blackduck.integration.jenkins.detect.DetectJenkinsEnvironmentVariable;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.blackduck.integration.util.IntEnvironmentVariables;
import hudson.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.types.Commandline;

public class DetectArgumentService {
    private static final String DETECT_LOGLEVEL_ARGUMENT = "logging.level.detect";
    private static final String DETECT_PHONEHOME_JENKINS_VERSION_ARGUMENT = "detect.phone.home.passthrough.jenkins.version";
    private static final String DETECT_PHONEHOME_PLUGIN_VERSION_ARGUMENT = "detect.phone.home.passthrough.jenkins.plugin.version";
    private final JenkinsIntLogger logger;
    private final JenkinsVersionHelper jenkinsVersionHelper;

    public DetectArgumentService(JenkinsIntLogger logger, JenkinsVersionHelper jenkinsVersionHelper) {
        this.logger = logger;
        this.jenkinsVersionHelper = jenkinsVersionHelper;
    }

    public List<String> getDetectArguments(IntEnvironmentVariables intEnvironmentVariables, Function<String, String> strategyEscaper, List<String> initialArguments, String detectArgumentString) {
        boolean shouldEscape = Boolean.parseBoolean(intEnvironmentVariables.getValue(DetectJenkinsEnvironmentVariable.SHOULD_ESCAPE.stringValue(), "true"));
        Function<String, String> argumentEscaper = shouldEscape ? strategyEscaper : Function.identity();
        ArrayList<String> detectArguments = new ArrayList<String>();
        detectArguments.addAll(initialArguments);
        detectArguments.addAll(this.parseDetectArgumentString(intEnvironmentVariables.getVariables(), argumentEscaper, detectArgumentString));
        if (detectArguments.stream().noneMatch(argument -> argument.contains(DETECT_LOGLEVEL_ARGUMENT))) {
            detectArguments.add(this.asEscapedDetectArgument(argumentEscaper, DETECT_LOGLEVEL_ARGUMENT, this.logger.getLogLevel().toString()));
        }
        String jenkinsVersion = this.jenkinsVersionHelper.getJenkinsVersion().orElse("<unknown>");
        String pluginVersion = this.jenkinsVersionHelper.getPluginVersion("blackduck-detect").orElse("<unknown>");
        detectArguments.add(this.asEscapedDetectArgument(argumentEscaper, DETECT_PHONEHOME_JENKINS_VERSION_ARGUMENT, jenkinsVersion));
        detectArguments.add(this.asEscapedDetectArgument(argumentEscaper, DETECT_PHONEHOME_PLUGIN_VERSION_ARGUMENT, pluginVersion));
        return detectArguments;
    }

    private String asEscapedDetectArgument(Function<String, String> escaper, String key, String rawValue) {
        return String.format("--%s=%s", key, escaper.apply(rawValue));
    }

    public List<String> parseDetectArgumentString(Map<String, String> environmentVariables, Function<String, String> argumentEscaper, String argumentString) {
        return Arrays.stream(Commandline.translateCommandline((String)argumentString)).map(argumentBlobString -> argumentBlobString.split("\\r?\\n")).flatMap(Arrays::stream).map(argument -> Util.replaceMacro((String)argument, (Map)environmentVariables)).filter(this::validateExpandedArguments).filter(Objects::nonNull).map(argument -> this.escapeArgument((String)argument, argumentEscaper)).collect(Collectors.toList());
    }

    private boolean validateExpandedArguments(String argument) {
        if (StringUtils.isBlank((CharSequence)argument)) {
            return false;
        }
        if (argument.contains("$")) {
            this.logger.warn("A variable may not have been properly replaced in resolved argument: " + argument + ". Make sure the variable has been properly defined.");
        }
        return true;
    }

    private String escapeArgument(String argument, Function<String, String> escaper) {
        String cleanedArg = argument;
        if (argument.startsWith("--") && argument.contains("=") && !argument.contains("&")) {
            String[] splitArgument = argument.split("=", 2);
            String endArg = splitArgument[0].contains("blackduck.api.token") ? splitArgument[1] : escaper.apply(splitArgument[1]);
            cleanedArg = splitArgument[0] + "=" + endArg;
        }
        return cleanedArg;
    }
}

