/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.extensions;

import com.blackduck.integration.jenkins.detect.extensions.DetectDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.tool.DetectAirGapInstallation;
import hudson.Extension;
import hudson.tools.ToolInstallation;
import hudson.util.ListBoxModel;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AirGapDownloadStrategy
extends DetectDownloadStrategy {
    private static final long serialVersionUID = -8683774675699706747L;
    public static final String DISPLAY_NAME = "Install AirGapped Detect as a Tool Installation";
    @Nullable
    private String airGapInstallationName;

    @DataBoundConstructor
    public AirGapDownloadStrategy() {
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getAirGapInstallationName() {
        return this.airGapInstallationName;
    }

    @DataBoundSetter
    public void setAirGapInstallationName(String airGapInstallationName) {
        this.airGapInstallationName = airGapInstallationName;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Extension
    public static class DescriptorImpl
    extends DetectDownloadStrategy.DownloadStrategyDescriptor {
        public DescriptorImpl() {
            super(AirGapDownloadStrategy.class);
            this.load();
        }

        public ListBoxModel doFillAirGapInstallationNameItems() {
            DetectAirGapInstallation.DescriptorImpl detectAirGapInstallationDescriptor = (DetectAirGapInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(DetectAirGapInstallation.DescriptorImpl.class));
            if (detectAirGapInstallationDescriptor == null) {
                return new ListBoxModel();
            }
            return Stream.of(detectAirGapInstallationDescriptor.getInstallations()).map(ToolInstallation::getName).map(ListBoxModel.Option::new).collect(Collectors.toCollection(ListBoxModel::new));
        }

        @Nonnull
        public String getDisplayName() {
            return AirGapDownloadStrategy.DISPLAY_NAME;
        }
    }
}

