/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.util;

import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.util.IssueKeyStringExtractor;
import com.atlassian.jira.cloud.jenkins.util.ScmRevision;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchNameIssueKeyExtractor
implements IssueKeyExtractor {
    private static final Logger logger = LoggerFactory.getLogger(BranchNameIssueKeyExtractor.class);

    @Override
    public Set<String> extractIssueKeys(WorkflowRun build) {
        SCMRevisionAction scmAction = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
        if (scmAction == null) {
            logger.debug("SCMRevisionAction is null");
            return Collections.emptySet();
        }
        SCMRevision revision = scmAction.getRevision();
        ScmRevision scmRevision = new ScmRevision(revision.getHead().getName());
        return this.extractIssueKeys(scmRevision);
    }

    private Set<String> extractIssueKeys(ScmRevision scmRevision) {
        return IssueKeyStringExtractor.extractIssueKeys(scmRevision.getHead()).stream().map(IssueKey::toString).collect(Collectors.toSet());
    }
}

