/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.checkgatingstatus.service;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.client.model.DetailKeyResponse;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.client.model.GatingStatus;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.client.model.GatingStatusResponse;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JiraGatingStatusResponse
extends JiraSendInfoResponse {
    private final GatingStatus gatingStatus;

    public JiraGatingStatusResponse(JiraSendInfoResponse.Status status, String message, @Nullable GatingStatus gatingStatus) {
        super(status, message);
        this.gatingStatus = gatingStatus;
    }

    public static JiraGatingStatusResponse of(JiraSendInfoResponse response) {
        return new JiraGatingStatusResponse(response.getStatus(), response.getMessage(), null);
    }

    public static JiraGatingStatusResponse success(GatingStatusResponse gatingStatusResponse) {
        String relatedIssues = gatingStatusResponse.getDetailKeyResponse().stream().map(DetailKeyResponse::getIssueLink).collect(Collectors.joining(", "));
        return new JiraGatingStatusResponse(JiraSendInfoResponse.Status.SUCCESS_GATE_CHECK, Messages.JiraGateStatusResponse_GATE_CHECK_SUCCESS(relatedIssues, (Object)gatingStatusResponse.getStatus()), gatingStatusResponse.getStatus());
    }

    public static JiraGatingStatusResponse failure(String message) {
        return new JiraGatingStatusResponse(JiraSendInfoResponse.Status.FAILURE_GATE_CHECK, message, null);
    }

    public Optional<GatingStatus> getGatingStatus() {
        return Optional.ofNullable(this.gatingStatus);
    }
}

