/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.checkgatingstatus.pipeline;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.client.model.GatingStatus;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.service.GatingStatusRequest;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.service.JiraGatingStatusResponse;
import com.atlassian.jira.cloud.jenkins.common.factory.JiraSenderFactory;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudPluginConfig;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JiraCheckGatingStatusStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String site;
    private String environmentId;

    @DataBoundConstructor
    public JiraCheckGatingStatusStep(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getSite() {
        return this.site;
    }

    @DataBoundSetter
    public void setSite(String site) {
        this.site = site;
    }

    public StepExecution start(StepContext context) {
        return new CheckGatingStatusExecution(context, this);
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    private static final class DeploymentAborted
    extends CauseOfInterruption {
        private DeploymentAborted() {
        }

        public String getShortDescription() {
            return Messages.JiraCheckGateStatusStep_CauseOfInterruption_Description();
        }
    }

    public static class CheckGatingStatusExecution
    extends SynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        private final JiraCheckGatingStatusStep step;

        public CheckGatingStatusExecution(StepContext context, JiraCheckGatingStatusStep step) {
            super(context);
            this.step = step;
        }

        protected Boolean run() throws Exception {
            TaskListener taskListener = (TaskListener)Objects.requireNonNull(this.getContext().get(TaskListener.class));
            WorkflowRun run = (WorkflowRun)Objects.requireNonNull(this.getContext().get(WorkflowRun.class));
            GatingStatusRequest gatingStatusRequest = new GatingStatusRequest(this.step.getSite(), this.step.getEnvironmentId(), run);
            JiraGatingStatusResponse response = JiraSenderFactory.getInstance().getJiraGateStateRetriever().getGatingStatus(gatingStatusRequest);
            this.logResult(taskListener, response);
            GatingStatus gatingStatus = response.getGatingStatus().orElseThrow(() -> new AbortException(response.getMessage()));
            switch (gatingStatus) {
                case ALLOWED: {
                    return true;
                }
                case EXPIRED: 
                case PREVENTED: {
                    Optional.ofNullable(run.getExecutor()).ifPresent(executor -> executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new DeploymentAborted()}));
                    return false;
                }
                case AWAITING: {
                    return false;
                }
            }
            throw new AbortException(response.getMessage());
        }

        private void logResult(TaskListener taskListener, JiraSendInfoResponse response) {
            taskListener.getLogger().println("checkGatingStatus: " + (Object)((Object)response.getStatus()) + ": " + response.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        @Inject
        private transient JiraCloudPluginConfig globalConfig;

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, WorkflowRun.class);
        }

        public ListBoxModel doFillSiteItems() {
            ListBoxModel items = new ListBoxModel();
            List<JiraCloudSiteConfig> siteList = this.globalConfig.getSites();
            for (JiraCloudSiteConfig siteConfig : siteList) {
                items.add(siteConfig.getSite(), siteConfig.getSite());
            }
            return items;
        }

        public String getFunctionName() {
            return "checkGatingStatus";
        }

        public String getDisplayName() {
            return Messages.JiraCheckGateStatusStep_DescriptorImpl_DisplayName();
        }
    }
}

