/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.BuildPayloadBuilder;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.BuildApiResponse;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.Builds;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoRequest;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoResponse;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSender;
import com.atlassian.jira.cloud.jenkins.common.client.JiraApi;
import com.atlassian.jira.cloud.jenkins.common.client.PostUpdateResult;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.common.response.JiraCommonResponse;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.IssueKeyStringExtractor;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProvider;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import hudson.model.Run;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraBuildInfoSenderImpl
implements JiraBuildInfoSender {
    private static final Logger log = LoggerFactory.getLogger(JiraBuildInfoSenderImpl.class);
    private static final String HTTPS_PROTOCOL = "https://";
    private final JiraSiteConfigRetriever siteConfigRetriever;
    private final SecretRetriever secretRetriever;
    private final IssueKeyExtractor issueKeyExtractor;
    private final CloudIdResolver cloudIdResolver;
    private final AccessTokenRetriever accessTokenRetriever;
    private final JiraApi buildsApi;
    private final RunWrapperProvider runWrapperProvider;

    public JiraBuildInfoSenderImpl(JiraSiteConfigRetriever siteConfigRetriever, SecretRetriever secretRetriever, IssueKeyExtractor issueKeyExtractor, CloudIdResolver cloudIdResolver, AccessTokenRetriever accessTokenRetriever, JiraApi buildsApi, RunWrapperProvider runWrapperProvider) {
        this.siteConfigRetriever = Objects.requireNonNull(siteConfigRetriever);
        this.secretRetriever = Objects.requireNonNull(secretRetriever);
        this.issueKeyExtractor = Objects.requireNonNull(issueKeyExtractor);
        this.cloudIdResolver = Objects.requireNonNull(cloudIdResolver);
        this.accessTokenRetriever = Objects.requireNonNull(accessTokenRetriever);
        this.buildsApi = Objects.requireNonNull(buildsApi);
        this.runWrapperProvider = Objects.requireNonNull(runWrapperProvider);
    }

    @Override
    public JiraSendInfoResponse sendBuildInfo(JiraBuildInfoRequest request) {
        String jiraSite = request.getSite();
        WorkflowRun build = request.getBuild();
        Optional<JiraCloudSiteConfig> maybeSiteConfig = this.getSiteConfigFor(jiraSite);
        if (!maybeSiteConfig.isPresent()) {
            return JiraCommonResponse.failureSiteConfigNotFound(jiraSite);
        }
        String resolvedSiteConfig = maybeSiteConfig.get().getSite();
        JiraCloudSiteConfig siteConfig = maybeSiteConfig.get();
        Optional<String> maybeSecret = this.getSecretFor(siteConfig.getCredentialsId());
        if (!maybeSecret.isPresent()) {
            return JiraCommonResponse.failureSecretNotFound(resolvedSiteConfig);
        }
        Set<String> issueKeys = this.getIssueKeys(request, build);
        if (issueKeys.isEmpty()) {
            return JiraBuildInfoResponse.skippedIssueKeysNotFound();
        }
        Optional<String> maybeCloudId = this.getCloudIdFor(resolvedSiteConfig);
        if (!maybeCloudId.isPresent()) {
            return JiraCommonResponse.failureSiteNotFound(resolvedSiteConfig);
        }
        Optional<String> maybeAccessToken = this.getAccessTokenFor(siteConfig, maybeSecret.get());
        if (!maybeAccessToken.isPresent()) {
            return JiraCommonResponse.failureAccessToken(resolvedSiteConfig);
        }
        Builds buildInfo = this.createJiraBuildInfo((Run)build, issueKeys);
        PostUpdateResult<BuildApiResponse> postUpdateResult = this.sendBuildInfo(maybeCloudId.get(), maybeAccessToken.get(), resolvedSiteConfig, buildInfo);
        if (postUpdateResult.getResponseEntity().isPresent()) {
            return this.handleBuildApiResponse(resolvedSiteConfig, postUpdateResult.getResponseEntity().get());
        }
        String errorMessage = postUpdateResult.getErrorMessage().orElse("");
        return this.handleBuildApiError(resolvedSiteConfig, errorMessage);
    }

    private Set<String> getIssueKeys(JiraBuildInfoRequest request, WorkflowRun build) {
        return Optional.ofNullable(request.getBranch()).map(branch -> IssueKeyStringExtractor.extractIssueKeys(branch).stream().map(IssueKey::toString).collect(Collectors.toSet())).orElseGet(() -> this.issueKeyExtractor.extractIssueKeys(build));
    }

    private Optional<JiraCloudSiteConfig> getSiteConfigFor(@Nullable String jiraSite) {
        return this.siteConfigRetriever.getJiraSiteConfig(jiraSite);
    }

    private Optional<String> getCloudIdFor(String jiraSite) {
        String jiraSiteUrl = HTTPS_PROTOCOL + jiraSite;
        return this.cloudIdResolver.getCloudId(jiraSiteUrl);
    }

    private Optional<String> getAccessTokenFor(JiraCloudSiteConfig siteConfig, String secret) {
        AppCredential appCredential = new AppCredential(siteConfig.getClientId(), secret);
        return this.accessTokenRetriever.getAccessToken(appCredential);
    }

    private Optional<String> getSecretFor(String credentialsId) {
        return this.secretRetriever.getSecretFor(credentialsId);
    }

    private Builds createJiraBuildInfo(Run build, Set<String> issueKeys) {
        RunWrapper buildWrapper = this.runWrapperProvider.getWrapper(build);
        return BuildPayloadBuilder.getBuildPayload(buildWrapper, issueKeys);
    }

    private PostUpdateResult<BuildApiResponse> sendBuildInfo(String cloudId, String accessToken, String jiraSite, Builds buildInfo) {
        return this.buildsApi.postUpdate(cloudId, accessToken, jiraSite, buildInfo, BuildApiResponse.class);
    }

    private JiraBuildInfoResponse handleBuildApiResponse(String jiraSite, BuildApiResponse response) {
        if (!response.getAcceptedBuilds().isEmpty()) {
            return JiraBuildInfoResponse.successBuildAccepted(jiraSite, response);
        }
        if (!response.getRejectedBuilds().isEmpty()) {
            return JiraBuildInfoResponse.failureBuildRejected(jiraSite, response);
        }
        if (!response.getUnknownIssueKeys().isEmpty()) {
            return JiraBuildInfoResponse.failureUnknownIssueKeys(jiraSite, response);
        }
        return JiraBuildInfoResponse.failureUnexpectedResponse();
    }

    private JiraBuildInfoResponse handleBuildApiError(String jiraSite, String errorMessage) {
        return JiraBuildInfoResponse.failureBuildsApiResponse(jiraSite, errorMessage);
    }
}

