/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.pipeline;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoRequest;
import com.atlassian.jira.cloud.jenkins.common.factory.JiraSenderFactory;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudPluginConfig;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JiraSendBuildInfoStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String site;
    private String branch;

    @DataBoundConstructor
    public JiraSendBuildInfoStep() {
    }

    @Nullable
    public String getSite() {
        return this.site;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @DataBoundSetter
    public void setSite(String site) {
        this.site = site;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new JiraSendBuildInfoStepExecution(stepContext, this);
    }

    public static class JiraSendBuildInfoStepExecution
    extends SynchronousNonBlockingStepExecution<JiraSendInfoResponse> {
        private final JiraSendBuildInfoStep step;

        public JiraSendBuildInfoStepExecution(StepContext context, JiraSendBuildInfoStep step) {
            super(context);
            this.step = step;
        }

        protected JiraSendInfoResponse run() throws Exception {
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            WorkflowRun workflowRun = (WorkflowRun)this.getContext().get(WorkflowRun.class);
            JiraBuildInfoRequest request = new JiraBuildInfoRequest(this.step.getSite(), this.step.getBranch(), workflowRun);
            JiraSendInfoResponse response = JiraSenderFactory.getInstance().getJiraBuildInfoSender().sendBuildInfo(request);
            this.logResult(taskListener, response);
            return response;
        }

        private void logResult(TaskListener taskListener, JiraSendInfoResponse response) {
            taskListener.getLogger().println("jiraSendBuildInfo: " + (Object)((Object)response.getStatus()) + ": " + response.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        @Inject
        private transient JiraCloudPluginConfig globalConfig;

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }

        public String getFunctionName() {
            return "jiraSendBuildInfo";
        }

        public String getDisplayName() {
            return Messages.JiraSendBuildInfoStep_DescriptorImpl_DisplayName();
        }

        public ListBoxModel doFillSiteItems() {
            ListBoxModel items = new ListBoxModel();
            List<JiraCloudSiteConfig> siteList = this.globalConfig.getSites();
            for (JiraCloudSiteConfig siteConfig : siteList) {
                items.add(siteConfig.getSite(), siteConfig.getSite());
            }
            return items;
        }
    }
}

