/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.auth;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenResponse;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRetriever {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenRetriever.class);
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private String accessTokenEndpoint;
    private static final String ACCESS_TOKEN_ENDPOINT = "https://api.atlassian.com/oauth/token";
    private static final String GRANT_TYPE = "client_credentials";

    @Inject
    public AccessTokenRetriever(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.accessTokenEndpoint = ACCESS_TOKEN_ENDPOINT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getAccessToken(AppCredential appCredential) {
        FormBody formBody = new FormBody.Builder().add("client_id", appCredential.getClientId()).add("client_secret", appCredential.getClientSecret()).add("grant_type", GRANT_TYPE).build();
        Request request = new Request.Builder().url(this.accessTokenEndpoint).post((RequestBody)formBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn(String.format("Error response code %d when retrieving access token for %s", response.code(), appCredential.getClientId()));
                Optional<String> optional = Optional.empty();
                return optional;
            }
            if (response.body() == null) {
                log.warn(String.format("Empty response when retrieving access token for %s", appCredential.getClientId()));
                Optional<String> optional = Optional.empty();
                return optional;
            }
            AccessTokenResponse accessTokenResponse = (AccessTokenResponse)this.objectMapper.readValue(response.body().bytes(), AccessTokenResponse.class);
            Optional<String> optional = Optional.ofNullable(accessTokenResponse.getAccessToken());
            return optional;
        }
        catch (JsonParseException | JsonMappingException e) {
            log.error(String.format("Invalid JSON when retrieving access token for %s", appCredential.getClientId()), e);
            return Optional.empty();
        }
        catch (IOException e) {
            log.error(String.format("Server exception when access token for %s", appCredential.getClientId()), (Throwable)e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    protected void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }
}

