/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.util;

import com.atlassian.jira.cloud.jenkins.util.ScmRevision;
import com.atlassian.jira.cloud.jenkins.util.ScmRevisionExtractor;
import hudson.model.Run;
import java.util.Optional;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmRevisionExtractorImpl
implements ScmRevisionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ScmRevisionExtractorImpl.class);

    @Override
    public Optional<ScmRevision> getScmRevision(Run build) {
        SCMRevisionAction scmAction = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
        if (scmAction == null) {
            logger.debug("SCMRevisionAction is null");
            return Optional.empty();
        }
        SCMRevision revision = scmAction.getRevision();
        ScmRevision scmRevision = new ScmRevision(revision.getHead().getName());
        return Optional.of(scmRevision);
    }
}

