/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.config;

import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class JiraCloudPluginConfig
extends GlobalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JiraCloudPluginConfig.class);
    private static final String ATL_JSW_GLOBAL_CONFIGURATION_ID = "atl-jsw-global-configuration";
    private List<JiraCloudSiteConfig> sites = new ArrayList<JiraCloudSiteConfig>();

    public JiraCloudPluginConfig() {
        this.load();
    }

    @Nullable
    public static JiraCloudPluginConfig get() {
        return (JiraCloudPluginConfig)((Object)GlobalConfiguration.all().get(JiraCloudPluginConfig.class));
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            if (json != null && json.isEmpty()) {
                this.setSites(Collections.emptyList());
            }
            req.bindJSON((Object)this, json);
        }
        catch (Exception e) {
            log.debug("Submitting form to JSW Plugin failed: ({})", (Object)e.getMessage(), (Object)e);
            if (log.isTraceEnabled()) {
                log.trace("JSW form data: {}", (Object)json.toString());
            }
            throw new Descriptor.FormException(String.format("Incorrect JSW Configuration (%s)", e.getMessage()), (Throwable)e, "configs");
        }
        this.save();
        return true;
    }

    public String getId() {
        return ATL_JSW_GLOBAL_CONFIGURATION_ID;
    }

    public List<JiraCloudSiteConfig> getSites() {
        return this.sites;
    }

    public void setSites(List<JiraCloudSiteConfig> sites) {
        this.sites = sites;
    }

    public static Optional<JiraCloudSiteConfig> getJiraCloudSiteConfig(String site) {
        return JiraCloudPluginConfig.get().getSites().stream().filter(s -> s.getSite().equals(site)).findFirst();
    }
}

