/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.BuildPayloadBuilder;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.BuildsApi;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.BuildApiResponse;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.JiraBuildInfo;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoRequest;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoResponse;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSender;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProvider;
import com.atlassian.jira.cloud.jenkins.util.ScmRevision;
import com.atlassian.jira.cloud.jenkins.util.ScmRevisionExtractor;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import hudson.model.Run;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraBuildInfoSenderImpl
implements JiraBuildInfoSender {
    private static final Logger log = LoggerFactory.getLogger(JiraBuildInfoSenderImpl.class);
    private static final String HTTPS_PROTOCOL = "https://";
    private final JiraSiteConfigRetriever siteConfigRetriever;
    private final SecretRetriever secretRetriever;
    private final ScmRevisionExtractor scmRevisionExtractor;
    private final CloudIdResolver cloudIdResolver;
    private final AccessTokenRetriever accessTokenRetriever;
    private final BuildsApi buildsApi;
    private final RunWrapperProvider runWrapperProvider;

    public JiraBuildInfoSenderImpl(JiraSiteConfigRetriever siteConfigRetriever, SecretRetriever secretRetriever, ScmRevisionExtractor scmRevisionExtractor, CloudIdResolver cloudIdResolver, AccessTokenRetriever accessTokenRetriever, BuildsApi buildsApi, RunWrapperProvider runWrapperProvider) {
        this.siteConfigRetriever = Objects.requireNonNull(siteConfigRetriever);
        this.secretRetriever = Objects.requireNonNull(secretRetriever);
        this.scmRevisionExtractor = Objects.requireNonNull(scmRevisionExtractor);
        this.cloudIdResolver = Objects.requireNonNull(cloudIdResolver);
        this.accessTokenRetriever = Objects.requireNonNull(accessTokenRetriever);
        this.buildsApi = Objects.requireNonNull(buildsApi);
        this.runWrapperProvider = Objects.requireNonNull(runWrapperProvider);
    }

    @Override
    public JiraBuildInfoResponse sendBuildInfo(JiraBuildInfoRequest request) {
        String jiraSite = request.getSite();
        Run build = request.getBuild();
        Optional<JiraCloudSiteConfig> maybeSiteConfig = this.getSiteConfigFor(jiraSite);
        if (!maybeSiteConfig.isPresent()) {
            return JiraBuildInfoResponse.failureSiteConfigNotFound(build, jiraSite);
        }
        JiraCloudSiteConfig siteConfig = maybeSiteConfig.get();
        Optional<String> maybeSecret = this.getSecretFor(siteConfig.getCredentialsId());
        if (!maybeSecret.isPresent()) {
            return JiraBuildInfoResponse.failureSecretNotFound(build, jiraSite);
        }
        Optional<ScmRevision> maybeScmRevision = this.getScmRevisionFor(build);
        if (!maybeScmRevision.isPresent()) {
            return JiraBuildInfoResponse.failureScmRevisionNotFound(build);
        }
        ScmRevision scmRevision = maybeScmRevision.get();
        Set<String> issueKeys = this.extractIssueKeys(scmRevision);
        if (issueKeys.isEmpty()) {
            return JiraBuildInfoResponse.skippedIssueKeysNotFound(build, scmRevision.getHead());
        }
        Optional<String> maybeCloudId = this.getCloudIdFor(jiraSite);
        if (!maybeCloudId.isPresent()) {
            return JiraBuildInfoResponse.failureSiteNotFound(build, jiraSite);
        }
        Optional<String> maybeAccessToken = this.getAccessTokenFor(siteConfig, maybeSecret.get());
        if (!maybeAccessToken.isPresent()) {
            return JiraBuildInfoResponse.failureAccessToken(build, jiraSite);
        }
        JiraBuildInfo buildInfo = this.createJiraBuildInfo(build, issueKeys);
        return this.sendBuildInfo(maybeCloudId.get(), maybeAccessToken.get(), jiraSite, buildInfo).map(response -> this.handleBuildApiResponse(build, jiraSite, (BuildApiResponse)response)).orElseGet(() -> this.handleBuildApiError(build, jiraSite));
    }

    private Optional<JiraCloudSiteConfig> getSiteConfigFor(String jiraSite) {
        return this.siteConfigRetriever.getJiraSiteConfig(jiraSite);
    }

    private Optional<String> getCloudIdFor(String jiraSite) {
        String jiraSiteUrl = HTTPS_PROTOCOL + jiraSite;
        return this.cloudIdResolver.getCloudId(jiraSiteUrl);
    }

    private Optional<String> getAccessTokenFor(JiraCloudSiteConfig siteConfig, String secret) {
        AppCredential appCredential = new AppCredential(siteConfig.getClientId(), secret);
        return this.accessTokenRetriever.getAccessToken(appCredential);
    }

    private Optional<String> getSecretFor(String credentialsId) {
        return this.secretRetriever.getSecretFor(credentialsId);
    }

    private Optional<ScmRevision> getScmRevisionFor(Run build) {
        return this.scmRevisionExtractor.getScmRevision(build);
    }

    private Set<String> extractIssueKeys(ScmRevision scmRevision) {
        return IssueKeyExtractor.extractIssueKeys(scmRevision.getHead()).stream().map(IssueKey::toString).collect(Collectors.toSet());
    }

    private JiraBuildInfo createJiraBuildInfo(Run build, Set<String> issueKeys) {
        RunWrapper buildWrapper = this.runWrapperProvider.getWrapper(build);
        return BuildPayloadBuilder.getBuildInfo(buildWrapper, issueKeys);
    }

    private Optional<BuildApiResponse> sendBuildInfo(String cloudId, String accessToken, String jiraSite, JiraBuildInfo buildInfo) {
        return this.buildsApi.postBuildUpdate(cloudId, accessToken, jiraSite, buildInfo);
    }

    private JiraBuildInfoResponse handleBuildApiResponse(Run build, String jiraSite, BuildApiResponse response) {
        if (!response.getAcceptedBuilds().isEmpty()) {
            return JiraBuildInfoResponse.successBuildAccepted(build, jiraSite, response);
        }
        if (!response.getRejectedBuilds().isEmpty()) {
            return JiraBuildInfoResponse.failureBuildRejected(build, jiraSite, response);
        }
        if (!response.getUnknownIssueKeys().isEmpty()) {
            return JiraBuildInfoResponse.failureUnknownIssueKeys(build, jiraSite, response);
        }
        return JiraBuildInfoResponse.failureUnexpectedResponse(build, jiraSite);
    }

    private JiraBuildInfoResponse handleBuildApiError(Run build, String jiraSite) {
        return JiraBuildInfoResponse.failureBuildsApiResponse(build, jiraSite);
    }
}

