/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.BuildsApi;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSender;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSenderImpl;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetrieverImpl;
import com.atlassian.jira.cloud.jenkins.provider.HttpClientProvider;
import com.atlassian.jira.cloud.jenkins.provider.ObjectMapperProvider;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProviderImpl;
import com.atlassian.jira.cloud.jenkins.util.ScmRevisionExtractorImpl;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import okhttp3.OkHttpClient;

public final class JiraBuildInfoSenderFactory {
    private static JiraBuildInfoSenderFactory INSTANCE;
    private JiraBuildInfoSender jiraBuildInfoSender;

    private JiraBuildInfoSenderFactory() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        HttpClientProvider httpClientProvider = new HttpClientProvider();
        OkHttpClient httpClient = httpClientProvider.httpClient();
        ObjectMapper objectMapper = objectMapperProvider.objectMapper();
        JiraSiteConfigRetrieverImpl siteConfigRetriever = new JiraSiteConfigRetrieverImpl();
        ScmRevisionExtractorImpl scmRevisionExtractor = new ScmRevisionExtractorImpl();
        SecretRetriever secretRetriever = new SecretRetriever();
        CloudIdResolver cloudIdResolver = new CloudIdResolver(httpClient, objectMapper);
        AccessTokenRetriever accessTokenRetriever = new AccessTokenRetriever(httpClient, objectMapper);
        BuildsApi buildsApi = new BuildsApi(httpClient, objectMapper);
        this.jiraBuildInfoSender = new JiraBuildInfoSenderImpl(siteConfigRetriever, secretRetriever, scmRevisionExtractor, cloudIdResolver, accessTokenRetriever, buildsApi, new RunWrapperProviderImpl());
    }

    public static synchronized JiraBuildInfoSenderFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JiraBuildInfoSenderFactory();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    public static void setInstance(JiraBuildInfoSenderFactory instance) {
        INSTANCE = instance;
    }

    public JiraBuildInfoSender getJiraBuildInfoSender() {
        return this.jiraBuildInfoSender;
    }
}

